/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ynfuien.yupdatechecker.Lang;
import pl.ynfuien.yupdatechecker.commands.main.AdminCommand;
import pl.ynfuien.yupdatechecker.commands.updates.UpdatesCommand;
import pl.ynfuien.yupdatechecker.config.ConfigName;
import pl.ynfuien.yupdatechecker.config.PluginConfig;
import pl.ynfuien.yupdatechecker.core.Checker;
import pl.ynfuien.yupdatechecker.core.modrinth.ModrinthAPI;
import pl.ynfuien.yupdatechecker.libs.bstats.bukkit.Metrics;
import pl.ynfuien.yupdatechecker.libs.ydevlib.config.ConfigHandler;
import pl.ynfuien.yupdatechecker.libs.ydevlib.config.ConfigObject;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public final class YUpdateChecker
extends JavaPlugin {
    private static YUpdateChecker instance;
    private ModrinthAPI modrinthAPI = new ModrinthAPI(new ModrinthAPI.UserAgent("Ynfuien", this.getPluginMeta().getName(), this.getPluginMeta().getVersion(), "ynfuien@gmail.com"));
    private final Checker checker = new Checker(this);
    private final ConfigHandler configHandler = new ConfigHandler((Plugin)this);
    private ConfigObject config;

    public void onEnable() {
        instance = this;
        YLogger.setup("<dark_aqua>[<aqua>Y<gradient:white:#1BD96A>UpdateChecker</gradient><dark_aqua>] <white>", this.getComponentLogger());
        this.loadConfigs();
        this.loadLang();
        this.config = this.configHandler.getConfigObject(ConfigName.CONFIG);
        PluginConfig.load((ConfigurationSection)this.config.getConfig());
        this.setupCommands();
        new Metrics((Plugin)this, 22505);
        if (PluginConfig.onStartup) {
            Bukkit.getAsyncScheduler().runNow((Plugin)instance, task -> {
                HashMap<String, Object> placeholders = new HashMap<String, Object>(){
                    {
                        this.put("command", "updates");
                    }
                };
                ConsoleCommandSender console = Bukkit.getConsoleSender();
                Lang.Message.COMMAND_UPDATES_CHECK_START.send((CommandSender)console, placeholders);
                this.checker.check().thenAcceptAsync(checkResult -> {
                    if (checkResult == null) {
                        Lang.Message.COMMAND_UPDATES_CHECK_FAIL.send((CommandSender)console, placeholders);
                        return;
                    }
                    Lang.Message.COMMAND_UPDATES_CHECK_FINISH.send((CommandSender)console, placeholders);
                });
            });
        }
        YLogger.info("Plugin successfully <green>enabled<white>!");
    }

    public void onDisable() {
        this.checker.stopCheck();
        YLogger.info("Plugin successfully <red>disabled<white>!");
    }

    private void setupCommands() {
        HashMap<String, Object> commands = new HashMap<String, Object>();
        commands.put("yupdatechecker", new AdminCommand(this));
        commands.put("updates", new UpdatesCommand(this));
        for (String name : commands.keySet()) {
            CommandExecutor cmd = (CommandExecutor)commands.get(name);
            this.getCommand(name).setExecutor(cmd);
            this.getCommand(name).setTabCompleter((TabCompleter)cmd);
        }
    }

    private void loadLang() {
        FileConfiguration config = this.configHandler.getConfig(ConfigName.LANG);
        Lang.loadLang(config);
    }

    private void loadConfigs() {
        this.configHandler.load(ConfigName.CONFIG);
        this.configHandler.load(ConfigName.LANG, true, true);
    }

    public boolean reloadPlugin() {
        boolean fullSuccess = this.configHandler.reloadAll();
        PluginConfig.load((ConfigurationSection)this.config.getConfig());
        instance.loadLang();
        return fullSuccess;
    }

    public static YUpdateChecker getInstance() {
        return instance;
    }

    public ModrinthAPI getModrinthAPI() {
        return this.modrinthAPI;
    }

    public Checker getChecker() {
        return this.checker;
    }
}

