/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.commands.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ynfuien.yupdatechecker.Lang;
import pl.ynfuien.yupdatechecker.YUpdateChecker;
import pl.ynfuien.yupdatechecker.commands.Subcommand;
import pl.ynfuien.yupdatechecker.commands.main.ReloadSubcommand;
import pl.ynfuien.yupdatechecker.commands.main.VersionSubcommand;

public class AdminCommand
implements CommandExecutor,
TabCompleter {
    private final YUpdateChecker instance;
    private final Subcommand[] subcommands;

    public AdminCommand(YUpdateChecker instance) {
        this.instance = instance;
        this.subcommands = new Subcommand[]{new ReloadSubcommand(instance), new VersionSubcommand(instance)};
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, final @NotNull String label, @NotNull String[] args) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>(){
            {
                this.put("command", label);
            }
        };
        if (args.length == 0) {
            Lang.Message.COMMAND_ADMIN_USAGE.send(sender, placeholders);
            return true;
        }
        String arg1 = args[0].toLowerCase();
        for (Subcommand cmd : this.subcommands) {
            if (!cmd.name().equals(arg1)) continue;
            String[] argsLeft = Arrays.copyOfRange(args, 1, args.length);
            cmd.run(sender, argsLeft, placeholders);
            return true;
        }
        Lang.Message.COMMAND_ADMIN_USAGE.send(sender, placeholders);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return AdminCommand.tabCompleteSubcommands(sender, this.subcommands, args);
    }

    public static List<String> tabCompleteSubcommands(CommandSender sender, Subcommand[] subcommands, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<Subcommand> canUse = Arrays.stream(subcommands).filter(cmd -> sender.hasPermission(cmd.permission())).toList();
        if (canUse.isEmpty()) {
            return completions;
        }
        String arg1 = args[0].toLowerCase();
        if (args.length == 1) {
            for (Subcommand cmd2 : canUse) {
                String name = cmd2.name();
                if (!name.startsWith(args[0])) continue;
                completions.add(name);
            }
            return completions;
        }
        Subcommand subcommand = canUse.stream().filter(cmd -> cmd.name().equals(arg1)).findAny().orElse(null);
        if (subcommand == null) {
            return completions;
        }
        List<String> subcommandCompletions = subcommand.getTabCompletions(sender, Arrays.copyOfRange(args, 1, args.length));
        if (subcommandCompletions != null) {
            return subcommandCompletions;
        }
        return completions;
    }
}

