/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.commands.updates;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import pl.ynfuien.yupdatechecker.Lang;
import pl.ynfuien.yupdatechecker.YUpdateChecker;
import pl.ynfuien.yupdatechecker.commands.Subcommand;
import pl.ynfuien.yupdatechecker.config.PluginConfig;
import pl.ynfuien.yupdatechecker.core.CheckResult;
import pl.ynfuien.yupdatechecker.core.Checker;
import pl.ynfuien.yupdatechecker.libs.ydevlib.utils.CommonPlaceholders;

public class CheckSubcommand
implements Subcommand {
    private final YUpdateChecker instance;
    private final Checker checker;

    public CheckSubcommand(YUpdateChecker instance) {
        this.instance = instance;
        this.checker = instance.getChecker();
    }

    @Override
    public String permission() {
        return "yupdatechecker.updates." + this.name();
    }

    @Override
    public String name() {
        return "check";
    }

    @Override
    public String description() {
        return Lang.Message.COMMAND_UPDATES_CHECK_DESCRIPTION.get();
    }

    @Override
    public String usage() {
        return null;
    }

    @Override
    public void run(CommandSender sender, String[] args, HashMap<String, Object> placeholders) {
        Duration dur;
        if (this.checker.isCheckRunning()) {
            Lang.Message.COMMAND_UPDATES_CHECK_FAIL_IS_RUNNING.send(sender, placeholders);
            return;
        }
        CheckResult lastCheck = this.checker.getLastCheck();
        if (!(lastCheck == null || args.length > 0 && args[0].equalsIgnoreCase("-y") || (dur = Duration.ofMillis(System.currentTimeMillis() - lastCheck.times().end())).toMinutes() >= (long)PluginConfig.confirmDuration)) {
            CommonPlaceholders.setDuration(placeholders, dur, null);
            Lang.Message.COMMAND_UPDATES_CHECK_FAIL_RECENT.send(sender, placeholders);
            return;
        }
        Lang.Message.COMMAND_UPDATES_CHECK_START.send(sender, placeholders);
        this.checker.check().thenAcceptAsync(checkResult -> {
            if (checkResult == null) {
                Lang.Message.COMMAND_UPDATES_CHECK_FAIL.send(sender, placeholders);
                return;
            }
            Lang.Message.COMMAND_UPDATES_CHECK_FINISH.send(sender, placeholders);
        });
        if (!PluginConfig.actionBarEnable) {
            return;
        }
        if (!(sender instanceof Player)) {
            return;
        }
        Player p = (Player)sender;
        Checker.CurrentCheck currentCheck = this.checker.getCurrentCheck();
        Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.instance, task -> {
            if (!p.isOnline()) {
                task.cancel();
                return;
            }
            Lang.Message message = null;
            placeholders.put("progress", currentCheck.getProgress());
            placeholders.put("goal", currentCheck.getGoal());
            placeholders.put("requests-sent", currentCheck.getRequestsSent());
            Checker.CheckState state = currentCheck.getState();
            switch (state) {
                case HASHING: {
                    message = Lang.Message.CHECK_PROGRESS_ACTION_BAR_HASHING;
                    break;
                }
                case CHECKING_HASHES: {
                    message = Lang.Message.CHECK_PROGRESS_ACTION_BAR_CHECKING_HASHES;
                    break;
                }
                case GETTING_PROJECTS: {
                    message = Lang.Message.CHECK_PROGRESS_ACTION_BAR_GETTING_PROJECTS;
                    break;
                }
                case GETTING_VERSIONS: {
                    message = Lang.Message.CHECK_PROGRESS_ACTION_BAR_GETTING_VERSIONS;
                }
            }
            if (message != null) {
                p.sendActionBar(message.getComponent(sender, placeholders));
            }
            if (!this.checker.isCheckRunning()) {
                task.cancel();
            }
        }, 100L, (long)PluginConfig.actionBarInterval * 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        return List.of();
    }
}

