/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.commands.updates;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.ynfuien.yupdatechecker.Lang;
import pl.ynfuien.yupdatechecker.YUpdateChecker;
import pl.ynfuien.yupdatechecker.commands.Subcommand;
import pl.ynfuien.yupdatechecker.commands.main.AdminCommand;
import pl.ynfuien.yupdatechecker.commands.updates.CheckSubcommand;
import pl.ynfuien.yupdatechecker.commands.updates.ShowSubcommand;

public class UpdatesCommand
implements CommandExecutor,
TabCompleter {
    private final YUpdateChecker instance;
    private final Subcommand[] subcommands;

    public UpdatesCommand(YUpdateChecker instance) {
        this.instance = instance;
        this.subcommands = new Subcommand[]{new CheckSubcommand(instance), new ShowSubcommand(instance)};
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, final @NotNull String label, @NotNull String[] args) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>(){
            {
                this.put("command", label);
            }
        };
        if (args.length == 0) {
            this.sendHelp(sender, placeholders);
            return true;
        }
        String arg1 = args[0].toLowerCase();
        for (Subcommand subcommand : this.subcommands) {
            if (!subcommand.name().equals(arg1)) continue;
            if (!sender.hasPermission(subcommand.permission())) break;
            String[] argsLeft = Arrays.copyOfRange(args, 1, args.length);
            subcommand.run(sender, argsLeft, placeholders);
            return true;
        }
        this.sendHelp(sender, placeholders);
        return true;
    }

    private void sendHelp(CommandSender sender, HashMap<String, Object> placeholders) {
        List<Subcommand> permittedCmds = Arrays.stream(this.subcommands).filter(subcommand -> sender.hasPermission(subcommand.permission())).toList();
        if (permittedCmds.isEmpty()) {
            Lang.Message.COMMAND_UPDATES_HELP_NO_COMMANDS.send(sender, placeholders);
            return;
        }
        Lang.Message.COMMAND_UPDATES_HELP_HEADER.send(sender, placeholders);
        for (Subcommand subcommand2 : permittedCmds) {
            String usage = subcommand2.usage();
            placeholders.put("subcommand", subcommand2.name() + (String)(usage == null ? "" : " " + subcommand2.usage()));
            placeholders.put("description", subcommand2.description());
            Lang.Message.COMMAND_UPDATES_HELP_ENTRY.send(sender, placeholders);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return AdminCommand.tabCompleteSubcommands(sender, this.subcommands, args);
    }
}

