/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.core;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import pl.ynfuien.yupdatechecker.YUpdateChecker;
import pl.ynfuien.yupdatechecker.config.PluginConfig;
import pl.ynfuien.yupdatechecker.core.CheckResult;
import pl.ynfuien.yupdatechecker.core.ProjectCheckResult;
import pl.ynfuien.yupdatechecker.core.ProjectFile;
import pl.ynfuien.yupdatechecker.core.modrinth.ModrinthAPI;
import pl.ynfuien.yupdatechecker.core.modrinth.model.GameVersion;
import pl.ynfuien.yupdatechecker.core.modrinth.model.Project;
import pl.ynfuien.yupdatechecker.core.modrinth.model.ProjectVersion;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public class Checker {
    private final YUpdateChecker instance;
    private final ModrinthAPI modrinthAPI;
    private static final List<String> SUPPORTED_LOADERS = Checker.getSupportedLoaders();
    private static final List<String> MINECRAFT_VERSIONS = new ArrayList<String>();
    private static final String SUPPORTED_VERSION = Bukkit.getMinecraftVersion();
    private static final Comparator<ProjectCheckResult> PROJECT_COMPARATOR = (left, right) -> left.project().getTitle().compareToIgnoreCase(right.project().getTitle());
    private CheckResult lastCheck = null;
    private boolean isCheckRunning = false;
    private final CurrentCheck currentCheck = new CurrentCheck(this);
    private boolean stopCheck = false;

    public Checker(YUpdateChecker instance) {
        this.instance = instance;
        this.modrinthAPI = instance.getModrinthAPI();
    }

    private List<String> getMinecraftVersions() {
        List<GameVersion> versions;
        try {
            this.currentCheck.incrementRequests();
            versions = this.modrinthAPI.getGameVersionTags();
        }
        catch (IOException | InterruptedException e) {
            YLogger.error("An error occurred while fetching Minecraft versions:");
            e.printStackTrace();
            return null;
        }
        ArrayList<String> mcVersions = new ArrayList<String>();
        for (GameVersion gameVersion : versions) {
            if (!gameVersion.getVersionType().equalsIgnoreCase("release")) continue;
            String version = gameVersion.getVersion();
            mcVersions.add(version);
            if (!version.equals(SUPPORTED_VERSION)) continue;
            break;
        }
        return mcVersions;
    }

    public CompletableFuture<CheckResult> check() {
        if (this.isCheckRunning) {
            return null;
        }
        this.isCheckRunning = true;
        this.currentCheck.reset();
        CompletableFuture<CheckResult> future = new CompletableFuture<CheckResult>();
        Bukkit.getAsyncScheduler().runNow((Plugin)this.instance, task -> {
            int i;
            List<Project> projects;
            List<ProjectVersion> currentVersions;
            long startTimestamp = System.currentTimeMillis();
            List<ProjectFile> pluginFiles = this.getPluginFiles();
            if (pluginFiles == null) {
                this.isCheckRunning = false;
                future.complete(null);
                return;
            }
            List<ProjectFile> dataPackFiles = this.getDataPackFiles();
            ArrayList<ProjectFile> files = new ArrayList<ProjectFile>(pluginFiles);
            files.addAll(dataPackFiles);
            this.currentCheck.setGoal(files.size());
            if (MINECRAFT_VERSIONS.isEmpty()) {
                List<String> versions = this.getMinecraftVersions();
                if (versions == null) {
                    this.isCheckRunning = false;
                    future.complete(null);
                    return;
                }
                MINECRAFT_VERSIONS.addAll(versions);
            }
            ArrayList<String> hashes = new ArrayList<String>();
            for (ProjectFile projectFile : files) {
                File file = projectFile.file();
                try {
                    HashCode hash = Files.asByteSource((File)file).hash(Hashing.sha512());
                    hashes.add(hash.toString());
                }
                catch (IOException e) {
                    YLogger.error(String.format("An error occurred while hashing file '%s'!", file.getName()));
                    e.printStackTrace();
                }
                this.currentCheck.incrementProgress();
            }
            this.currentCheck.incrementState();
            try {
                this.currentCheck.incrementRequests();
                currentVersions = this.modrinthAPI.getVersionFiles(hashes);
            }
            catch (IOException | InterruptedException e) {
                YLogger.error("An error occurred while getting project version files from hashes.");
                e.printStackTrace();
                return;
            }
            if (currentVersions == null) {
                return;
            }
            this.currentCheck.incrementState();
            try {
                this.currentCheck.incrementRequests();
                List<String> projectIds = currentVersions.stream().map(ProjectVersion::getProjectId).toList();
                projects = this.modrinthAPI.getProjects(projectIds);
            }
            catch (IOException | InterruptedException e) {
                YLogger.error("An error occurred while getting projects data.");
                e.printStackTrace();
                return;
            }
            if (projects == null) {
                return;
            }
            ArrayList pluginResults = new ArrayList();
            ArrayList dataPackResults = new ArrayList();
            this.currentCheck.incrementState();
            this.currentCheck.setProgress(0);
            this.currentCheck.setGoal(projects.size());
            ArrayList projectsPerThread = new ArrayList();
            for (i = 0; i < PluginConfig.threads; ++i) {
                projectsPerThread.add(new ArrayList());
            }
            for (i = 0; i < projects.size(); ++i) {
                int n = i % PluginConfig.threads;
                ((List)projectsPerThread.get(n)).add(projects.get(i));
            }
            for (List list : projectsPerThread) {
                if (list.isEmpty()) continue;
                Bukkit.getAsyncScheduler().runNow((Plugin)this.instance, task2 -> {
                    CheckResult result;
                    for (Project project : projectList) {
                        List list;
                        List<ProjectVersion> newVersions;
                        if (this.stopCheck) {
                            return;
                        }
                        ProjectVersion currentVersion = null;
                        List list2 = currentVersions;
                        synchronized (list2) {
                            for (ProjectVersion ver : currentVersions) {
                                if (!ver.getProjectId().equals(project.getId())) continue;
                                currentVersion = ver;
                                break;
                            }
                            currentVersions.remove(currentVersion);
                        }
                        boolean isDataPack = currentVersion.getLoaders().contains("datapack");
                        try {
                            this.currentCheck.incrementRequests();
                            this.currentCheck.incrementProgress();
                            List<String> loaders = isDataPack ? List.of("datapack") : SUPPORTED_LOADERS;
                            newVersions = this.modrinthAPI.getProjectVersions(project.getSlug(), loaders, MINECRAFT_VERSIONS);
                        }
                        catch (IOException | InterruptedException e) {
                            YLogger.error(String.format("An error occurred while getting project versions for '%s'!", project.getSlug()));
                            e.printStackTrace();
                            continue;
                        }
                        if (newVersions == null) continue;
                        ProjectCheckResult projectCheck = new ProjectCheckResult(project, currentVersion, newVersions);
                        if (isDataPack) {
                            list = dataPackResults;
                            synchronized (list) {
                                dataPackResults.add(projectCheck);
                                continue;
                            }
                        }
                        list = pluginResults;
                        synchronized (list) {
                            pluginResults.add(projectCheck);
                        }
                    }
                    if (this.currentCheck.getProgress() != this.currentCheck.getGoal()) {
                        return;
                    }
                    pluginResults.sort(PROJECT_COMPARATOR);
                    dataPackResults.sort(PROJECT_COMPARATOR);
                    long endTimestamp = System.currentTimeMillis();
                    CheckResult.Times times = new CheckResult.Times(startTimestamp, endTimestamp);
                    this.lastCheck = result = new CheckResult(pluginResults, pluginFiles.size(), dataPackResults, dataPackFiles.size(), times, this.currentCheck.getRequestsSent());
                    this.isCheckRunning = false;
                    future.complete(result);
                });
            }
        });
        return future;
    }

    private List<ProjectFile> getPluginFiles() {
        File pluginsFolder = Bukkit.getPluginsFolder();
        File[] plugins = pluginsFolder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (plugins == null) {
            YLogger.error("Couldn't read plugin files!");
            return null;
        }
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
        for (File plugin : plugins) {
            if (plugin.isDirectory()) continue;
            result.add(new ProjectFile(plugin, ProjectFile.Type.PLUGIN));
        }
        return result;
    }

    private List<ProjectFile> getDataPackFiles() {
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
        for (World world : Bukkit.getWorlds()) {
            File folder = world.getWorldFolder();
            File dataPacksFolder = new File(folder, "datapacks");
            if (!dataPacksFolder.exists()) continue;
            File[] zips = dataPacksFolder.listFiles((dir, name) -> name.endsWith(".zip"));
            if (zips == null) {
                YLogger.error(String.format("Couldn't read datapack files of world '%s'!", world.getName()));
                continue;
            }
            for (File zip : zips) {
                if (zip.isDirectory()) continue;
                result.add(new ProjectFile(zip, ProjectFile.Type.DATAPACK));
            }
        }
        return result;
    }

    public boolean isCheckRunning() {
        return this.isCheckRunning;
    }

    public void stopCheck() {
        if (!this.isCheckRunning) {
            return;
        }
        this.stopCheck = true;
        Bukkit.getAsyncScheduler().cancelTasks((Plugin)this.instance);
    }

    public CurrentCheck getCurrentCheck() {
        return this.currentCheck;
    }

    public CheckResult getLastCheck() {
        return this.lastCheck;
    }

    private static List<String> getSupportedLoaders() {
        if (Checker.isRunningFolia()) {
            return List.of("folia");
        }
        if (Checker.isRunningPurpur()) {
            return List.of("bukkit", "spigot", "paper", "purpur");
        }
        if (Checker.isRunningPaper()) {
            return List.of("bukkit", "spigot", "paper");
        }
        if (Checker.isRunningSpigot()) {
            return List.of("bukkit", "spigot");
        }
        return List.of("bukkit");
    }

    private static boolean isRunningFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isRunningPurpur() {
        try {
            Class.forName("org.purpurmc.purpur.PurpurConfig");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isRunningPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isRunningSpigot() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public class CurrentCheck {
        private CheckState state = CheckState.HASHING;
        private final AtomicInteger progress = new AtomicInteger();
        private final AtomicInteger goal = new AtomicInteger();
        private final AtomicInteger requestsSent = new AtomicInteger();

        private CurrentCheck(Checker this$0) {
        }

        private void reset() {
            this.state = CheckState.HASHING;
            this.progress.set(0);
            this.goal.set(0);
            this.requestsSent.set(0);
        }

        private void incrementState() {
            switch (this.state.ordinal()) {
                case 0: {
                    this.state = CheckState.CHECKING_HASHES;
                    break;
                }
                case 1: {
                    this.state = CheckState.GETTING_PROJECTS;
                    break;
                }
                case 2: {
                    this.state = CheckState.GETTING_VERSIONS;
                }
            }
        }

        private void incrementProgress() {
            this.progress.incrementAndGet();
        }

        private void incrementRequests() {
            this.requestsSent.incrementAndGet();
        }

        private void setProgress(int value) {
            this.progress.set(value);
        }

        private void setGoal(int value) {
            this.goal.set(value);
        }

        public CheckState getState() {
            return this.state;
        }

        public int getProgress() {
            return this.progress.get();
        }

        public int getGoal() {
            return this.goal.get();
        }

        public int getRequestsSent() {
            return this.requestsSent.get();
        }
    }

    public static enum CheckState {
        HASHING,
        CHECKING_HASHES,
        GETTING_PROJECTS,
        GETTING_VERSIONS;

    }
}

