/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.core;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import pl.ynfuien.yupdatechecker.config.PluginConfig;
import pl.ynfuien.yupdatechecker.core.modrinth.model.Project;
import pl.ynfuien.yupdatechecker.core.modrinth.model.ProjectVersion;

public class ProjectCheckResult {
    private static final String MINECRAFT_VERSION = Bukkit.getMinecraftVersion();
    private final Project project;
    private final ProjectVersion currentVersion;
    private final List<ProjectVersion> newerVersions;
    private final ProjectVersion latestVersion;
    private final int versionsBehind;
    private boolean newerReleaseForNewerMcVersion;
    private boolean newerReleaseForDifferentChannel;

    public ProjectCheckResult(Project project, ProjectVersion currentVersion, List<ProjectVersion> newerVersions) {
        this.project = project;
        this.currentVersion = currentVersion;
        this.newerVersions = newerVersions;
        ArrayList<ProjectVersion> fittingVersions = new ArrayList<ProjectVersion>();
        for (ProjectVersion version : newerVersions) {
            if (version.getId().equalsIgnoreCase(currentVersion.getId())) break;
            if (!PluginConfig.considerChannels.contains(version.getVersionType())) {
                this.newerReleaseForDifferentChannel = true;
                continue;
            }
            if (!version.getGameVersions().contains(MINECRAFT_VERSION)) {
                this.newerReleaseForNewerMcVersion = true;
                continue;
            }
            fittingVersions.add(version);
        }
        this.latestVersion = fittingVersions.isEmpty() ? currentVersion : (ProjectVersion)fittingVersions.get(0);
        this.versionsBehind = fittingVersions.size();
    }

    public Project project() {
        return this.project;
    }

    public ProjectVersion currentVersion() {
        return this.currentVersion;
    }

    public List<ProjectVersion> newerVersions() {
        return this.newerVersions;
    }

    public ProjectVersion latestVersion() {
        return this.latestVersion;
    }

    public int versionsBehind() {
        return this.versionsBehind;
    }

    public boolean isNewerReleaseForNewerMcVersion() {
        return this.newerReleaseForNewerMcVersion;
    }

    public boolean isNewerReleaseForDifferentChannel() {
        return this.newerReleaseForDifferentChannel;
    }

    public boolean upToDate() {
        return this.versionsBehind == 0;
    }
}

