/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.core.modrinth;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.moznion.uribuildertiny.URIBuilderTiny;
import pl.ynfuien.yupdatechecker.core.modrinth.model.GameVersion;
import pl.ynfuien.yupdatechecker.core.modrinth.model.Project;
import pl.ynfuien.yupdatechecker.core.modrinth.model.ProjectVersion;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public class ModrinthAPI {
    private static final String BASE_URL = "https://api.modrinth.com/v2";
    private final HttpClient httpClient;
    private final String userAgent;
    private final AtomicInteger ratelimitLimit = new AtomicInteger(300);
    private final AtomicInteger ratelimitLeft = new AtomicInteger(300);
    private final AtomicInteger ratelimitReset = new AtomicInteger(60);
    private static final Gson GSON = new Gson();
    private static final Type GSON_MAP_MAP_TYPE = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
    private static final Type GSON_ARRAY_TYPE = new TypeToken<List<Map<String, Object>>>(){}.getType();

    public ModrinthAPI(UserAgent agent) {
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(5L)).build();
        this.userAgent = agent.build();
    }

    public List<Project> getProjects(List<String> ids) throws InterruptedException, IOException {
        String url = String.format("%s/projects", BASE_URL);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", GSON.toJson(ids));
        String response = this.sendRequest(url, params);
        if (response == null) {
            return null;
        }
        List list = (List)GSON.fromJson(response, GSON_ARRAY_TYPE);
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Map item : list) {
            Project project = new Project(item);
            projects.add(project);
        }
        return projects;
    }

    public List<ProjectVersion> getProjectVersions(String slug, List<String> loaders, List<String> gameVersions) throws InterruptedException, IOException {
        String url = String.format("%s/project/%s/version", BASE_URL, slug);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("loaders", GSON.toJson(loaders));
        params.put("game_versions", GSON.toJson(gameVersions));
        String response = this.sendRequest(url, params);
        if (response == null) {
            return null;
        }
        List list = (List)GSON.fromJson(response, GSON_ARRAY_TYPE);
        ArrayList<ProjectVersion> versions = new ArrayList<ProjectVersion>();
        for (Map item : list) {
            ProjectVersion version = new ProjectVersion(item);
            versions.add(version);
        }
        return versions;
    }

    public List<ProjectVersion> getVersionFiles(List<String> hashes) throws InterruptedException, IOException {
        String url = String.format("%s/version_files", BASE_URL);
        JsonObject payload = new JsonObject();
        payload.addProperty("algorithm", "sha512");
        payload.add("hashes", (JsonElement)GSON.toJsonTree(hashes).getAsJsonArray());
        String json = GSON.toJson((JsonElement)payload);
        String response = this.sendRequest(url, null, json);
        if (response == null) {
            return null;
        }
        Map map = (Map)GSON.fromJson(response, GSON_MAP_MAP_TYPE);
        ArrayList<ProjectVersion> versions = new ArrayList<ProjectVersion>();
        for (Map item : map.values()) {
            ProjectVersion version = new ProjectVersion(item);
            versions.add(version);
        }
        return versions;
    }

    public List<GameVersion> getGameVersionTags() throws InterruptedException, IOException {
        String url = String.format("%s/tag/game_version", BASE_URL);
        String response = this.sendRequest(url);
        if (response == null) {
            return null;
        }
        List list = (List)GSON.fromJson(response, GSON_ARRAY_TYPE);
        ArrayList<GameVersion> versions = new ArrayList<GameVersion>();
        for (Map item : list) {
            GameVersion version = new GameVersion(item);
            versions.add(version);
        }
        return versions;
    }

    private String sendRequest(String url) throws IOException, InterruptedException {
        return this.sendRequest(url, null, null);
    }

    private String sendRequest(String url, HashMap<String, String> queryParams) throws IOException, InterruptedException {
        return this.sendRequest(url, queryParams, null);
    }

    private String sendRequest(String url, HashMap<String, String> queryParams, String postData) throws IOException, InterruptedException {
        URIBuilderTiny builder = new URIBuilderTiny(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.addQueryParameters(queryParams);
        }
        return this.sendRequest(builder.build(), postData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(URI uri, String postData) throws IOException, InterruptedException {
        if (this.ratelimitLeft.get() <= 0) {
            Thread.sleep((long)this.ratelimitReset.get() * 1000L + 1000L);
            AtomicInteger atomicInteger = this.ratelimitLeft;
            synchronized (atomicInteger) {
                if (this.ratelimitLeft.get() <= 0) {
                    this.ratelimitLeft.set(this.ratelimitLimit.get());
                }
            }
            return this.sendRequest(uri, postData);
        }
        this.ratelimitLeft.decrementAndGet();
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).header("User-Agent", this.userAgent).GET();
        if (postData != null) {
            builder.POST(HttpRequest.BodyPublishers.ofString(postData)).header("Content-Type", "application/json");
        }
        HttpResponse<String> response = this.httpClient.send(builder.build(), HttpResponse.BodyHandlers.ofString());
        HttpHeaders headers = response.headers();
        this.ratelimitLimit.set(Integer.parseInt(headers.firstValue("X-Ratelimit-Limit").orElse("300")));
        this.ratelimitLeft.set(Integer.parseInt(headers.firstValue("X-Ratelimit-Remaining").orElse("300")));
        this.ratelimitReset.set(Integer.parseInt(headers.firstValue("X-Ratelimit-Reset").orElse("60")));
        int code = response.statusCode();
        if (code == 429) {
            YLogger.error("Modrinth API ratelimit has been hit! Waiting for it to reset...");
            this.ratelimitLeft.set(0);
            return this.sendRequest(uri, postData);
        }
        return code == 200 ? response.body() : null;
    }

    public record UserAgent(String author, String projectName, String version, String contact) {
        public String build() {
            return String.format("%s/%s/%s (%s)", this.author, this.projectName, this.version, this.contact);
        }
    }
}

