/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.core.modrinth.model;

import com.google.gson.internal.LinkedTreeMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Project {
    private final String id;
    private final String slug;
    private final String title;
    private final String description;
    private final String body;
    private final String issuesUrl;
    private final String sourceUrl;
    private final String wikiUrl;
    private final String discordUrl;
    private final String iconUrl;
    private final String projectType;
    private final List<String> versions;
    private final List<String> gameVersions;
    private final List<String> loaders;
    private final int downloads;
    private final int followers;
    private final int color;
    private final String team;
    private final Instant published;
    private final Instant updated;
    private final License license;

    public Project(Map<String, Object> jsonMap) {
        this.id = (String)jsonMap.get("id");
        this.slug = (String)jsonMap.get("slug");
        this.title = (String)jsonMap.get("title");
        this.description = (String)jsonMap.get("description");
        this.body = (String)jsonMap.get("body");
        this.issuesUrl = (String)jsonMap.get("issues_url");
        this.sourceUrl = (String)jsonMap.get("source_url");
        this.wikiUrl = (String)jsonMap.get("wiki_url");
        this.discordUrl = (String)jsonMap.get("discord_url");
        this.iconUrl = (String)jsonMap.get("icon_url");
        this.projectType = (String)jsonMap.get("project_type");
        this.versions = (ArrayList)jsonMap.get("versions");
        this.gameVersions = (ArrayList)jsonMap.get("game_versions");
        this.loaders = (ArrayList)jsonMap.get("loaders");
        this.downloads = ((Double)jsonMap.get("downloads")).intValue();
        this.followers = ((Double)jsonMap.get("followers")).intValue();
        Object colorValue = jsonMap.get("color");
        this.color = colorValue == null ? 0 : ((Double)colorValue).intValue();
        this.team = (String)jsonMap.get("team");
        this.published = Instant.parse((String)jsonMap.get("published"));
        this.updated = Instant.parse((String)jsonMap.get("updated"));
        LinkedTreeMap treeMap = (LinkedTreeMap)jsonMap.get("license");
        this.license = new License((String)treeMap.get((Object)"id"), (String)treeMap.get((Object)"name"), (String)treeMap.get((Object)"url"));
    }

    public String getId() {
        return this.id;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBody() {
        return this.body;
    }

    public String getIssuesUrl() {
        return this.issuesUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getWikiUrl() {
        return this.wikiUrl;
    }

    public String getDiscordUrl() {
        return this.discordUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getGameVersions() {
        return this.gameVersions;
    }

    public List<String> getLoaders() {
        return this.loaders;
    }

    public int getDownloads() {
        return this.downloads;
    }

    public int getFollowers() {
        return this.followers;
    }

    public int getColor() {
        return this.color;
    }

    public String getTeam() {
        return this.team;
    }

    public Instant getPublished() {
        return this.published;
    }

    public Instant getUpdated() {
        return this.updated;
    }

    public License getLicense() {
        return this.license;
    }

    public record License(String id, String name, String url) {
    }
}

