/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import pl.ynfuien.yupdatechecker.libs.ydevlib.config.ConfigObject;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public class ConfigHandler {
    private final Plugin plugin;
    private final HashMap<ConfigObject.Name, ConfigObject> configs = new HashMap();

    public ConfigHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean load(ConfigObject.Name name) {
        return this.load(name, true);
    }

    public boolean load(ConfigObject.Name name, boolean updating) {
        return this.load(name, updating, false);
    }

    public boolean load(ConfigObject.Name name, boolean updating, boolean useDefault) {
        return this.load(name, updating, useDefault, new ArrayList<String>());
    }

    public boolean load(ConfigObject.Name name, boolean updating, boolean useDefault, List<String> ignoredKeys) {
        ConfigObject config = new ConfigObject(this.plugin, name);
        config.setUpdating(updating);
        config.setUseDefault(useDefault);
        config.setIgnoredKeys(ignoredKeys);
        if (config.load() == null) {
            this.logError("Fix the error and restart server.");
            Bukkit.getServer().getPluginManager().disablePlugin(this.plugin);
            return false;
        }
        this.configs.put(name, config);
        return true;
    }

    public void saveAll() {
        for (ConfigObject config : this.configs.values()) {
            config.save();
        }
    }

    public boolean reloadAll() {
        boolean noProblems = true;
        for (ConfigObject configObject : this.configs.values()) {
            if (configObject.reload()) continue;
            noProblems = false;
        }
        return noProblems;
    }

    public ConfigObject getConfigObject(ConfigObject.Name name) {
        return this.configs.get(name);
    }

    public FileConfiguration getConfig(ConfigObject.Name name) {
        ConfigObject config = this.configs.get(name);
        if (config == null) {
            return null;
        }
        return config.getConfig();
    }

    private void logError(String message) {
        YLogger.warn("[Configs] " + message);
    }

    private void logInfo(String message) {
        YLogger.info("[Configs] " + message);
    }
}

