/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.ynfuien.yupdatechecker.libs.ydevlib.config.updater.ConfigUpdater;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public class ConfigObject {
    private final Plugin plugin;
    private final Name name;
    private final String fileName;
    private final File file;
    private FileConfiguration config = new YamlConfiguration();
    private final FileConfiguration defaultConfig;
    private boolean updating = true;
    private boolean useDefault = false;
    private List<String> ignoredKeys = new ArrayList<String>();

    public ConfigObject(Plugin plugin, Name name) {
        this.plugin = plugin;
        this.name = name;
        this.fileName = name.getFileName();
        InputStream resourceStream = plugin.getResource(this.fileName);
        if (resourceStream == null) {
            throw new IllegalArgumentException(String.format("Config with name '%s' doesn't exist in resource folder!", this.fileName));
        }
        this.file = new File(plugin.getDataFolder(), this.fileName);
        this.defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
    }

    public FileConfiguration load() {
        this.logInfo("Loading...");
        boolean factoryNew = false;
        if (!this.file.exists()) {
            this.logInfo("Config doesn't exist, creating new...");
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource(this.fileName, false);
            factoryNew = true;
        }
        try {
            this.config.load(this.file);
            if (factoryNew) {
                return this.config;
            }
            if (!this.updating) {
                return this.config;
            }
            if (this.update()) {
                return this.config;
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            this.logError("An error occurred while loading config from file!");
        }
        if (!this.useDefault) {
            return null;
        }
        this.logError("Will be used default one...");
        this.config = this.defaultConfig;
        return this.defaultConfig;
    }

    private boolean update() {
        boolean isMissingKeys = false;
        block6: for (String key : this.defaultConfig.getKeys(true)) {
            if (this.config.contains(key) || this.ignoredKeys.contains(key)) continue;
            for (String dontUpdateKey : this.ignoredKeys) {
                if (!key.startsWith(dontUpdateKey + ".")) continue;
                continue block6;
            }
            isMissingKeys = true;
            break;
        }
        if (!isMissingKeys) {
            return true;
        }
        this.logError("Config is missing some keys, updating..");
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
        String[] split = this.fileName.split("\\.");
        String oldConfigName = String.format("%s-old_%s.%s", split[0], formatter.format(date), split[1]);
        this.logError("Old file will be saved as " + oldConfigName);
        File oldConfig = new File(this.plugin.getDataFolder(), oldConfigName);
        try {
            Files.copy(this.file.toPath(), oldConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logError("Couldn't backup current config.");
            return false;
        }
        try {
            ConfigUpdater.update(this.plugin, this.fileName, this.file, new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logError("Couldn't update config file.");
            return false;
        }
        try {
            this.config.load(this.file);
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            this.logError("Couldn't load updated config.");
            return false;
        }
    }

    public boolean save() {
        if (this.config == null) {
            return false;
        }
        try {
            ConfigUpdater.save(this.plugin, this.file, this.config);
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            this.logError("Couldn't save config!");
            return false;
        }
    }

    public boolean reload() {
        this.logInfo("Reloading...");
        String oldConfig = this.config.saveToString();
        if (this.load() == null) {
            this.logError("Config couldn't be reloaded!");
            try {
                this.config.loadFromString(oldConfig);
            }
            catch (InvalidConfigurationException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        this.logInfo("Reloaded!");
        return true;
    }

    private void logError(String message) {
        YLogger.warn(String.format("[Config] [%s] %s", this.name.getFileName(), message));
    }

    private void logInfo(String message) {
        YLogger.info(String.format("[Config] [%s] %s", this.name.getFileName(), message));
    }

    public Name getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getDefaultConfig() {
        return this.defaultConfig;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public List<String> getIgnoredKeys() {
        return this.ignoredKeys;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public void setIgnoredKeys(@NotNull List<String> ignoredKeys) {
        this.ignoredKeys = ignoredKeys;
    }

    public static interface Name {
        public String getFileName();
    }
}

