/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.guis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.GUIPanelHolder;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.GUISound;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.Item;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.listeners.InventoryClickListener;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.listeners.InventoryCloseListener;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.listeners.InventoryDragListener;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.listeners.PlayerQuitListener;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;
import pl.ynfuien.yupdatechecker.libs.ydevlib.utils.YamlHelper;

public abstract class GUIPanel {
    private static final HashMap<String, GUIPanel> guiPanels = new HashMap();
    protected final Plugin plugin;
    protected final String name;
    @Nullable
    protected String title = null;
    protected Short rows;
    protected int refreshRate = -1;
    @Nullable
    protected GUISound openSound = null;
    @Nullable
    protected GUISound closeSound = null;
    protected HashMap<String, Item> items = new HashMap();
    protected HashMap<Short, Item> slots = new HashMap();
    protected HashMap<UUID, GUIPanelHolder> inventories = new HashMap();
    private static boolean registered = false;

    protected GUIPanel(Plugin plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        guiPanels.put(name, this);
    }

    public boolean load(ConfigurationSection config) {
        if (!config.contains("rows")) {
            this.log("Missing key 'rows'");
            return false;
        }
        if (config.contains("title")) {
            this.title = config.getString("title");
        }
        try {
            this.rows = (short)config.getInt("rows");
        }
        catch (NumberFormatException e) {
            this.log("Rows number is incorrect!");
            return false;
        }
        if (this.rows > 6) {
            this.log("Rows number can't be higher than 6!");
            return false;
        }
        if (this.rows < 1) {
            this.log("Rows number can't be lower than 1!");
            return false;
        }
        if (config.contains("refresh-rate")) {
            this.refreshRate = config.getInt("refresh-rate");
        }
        if (this.refreshRate < 1) {
            this.refreshRate = -1;
        }
        for (String string : Arrays.asList("open-sound", "close-sound")) {
            boolean loaded;
            if (!config.contains(string)) continue;
            if (string.equals("open-sound")) {
                this.openSound = new GUISound(string);
                loaded = this.openSound.load(config.getConfigurationSection(string));
            } else {
                this.closeSound = new GUISound(string);
                loaded = this.closeSound.load(config.getConfigurationSection(string));
            }
            if (loaded) continue;
            this.log(String.format("%s couldn't be loaded!", string));
        }
        this.items.clear();
        if (config.contains("items")) {
            ConfigurationSection itemSection = config.getConfigurationSection("items");
            for (String itemName : itemSection.getKeys(false)) {
                Item item = Item.load(itemSection, itemName);
                if (item == null) {
                    this.log(String.format("Item '%s' couldn't be loaded!", itemName));
                    continue;
                }
                this.items.put(itemName.toLowerCase(), item);
            }
        }
        this.slots.clear();
        ConfigurationSection slotsSection = config.getConfigurationSection("slots");
        if (slotsSection == null) {
            return true;
        }
        int n = this.rows * 9 - 1;
        Set slotEntries = slotsSection.getKeys(false);
        for (String slotEntry : slotEntries) {
            Set<Integer> slotSet = YamlHelper.getIntSetFromRangePattern(slotEntry);
            if (slotSet.isEmpty()) {
                this.log(String.format("Slot entry '%s' is incorrect! It has to be a number or an entry in the format '{number}-{number}'.", slotEntry));
                continue;
            }
            Iterator<Integer> iterator = slotSet.iterator();
            while (iterator.hasNext()) {
                int slot = iterator.next();
                if (slot < 0) {
                    this.log(String.format("Slot number '%d' is lower than 0!", slot));
                    iterator.remove();
                    continue;
                }
                if (slot <= n) continue;
                this.log(String.format("Slot number '%d' is higher than %d!", slot, n));
                iterator.remove();
            }
            Item item = this.getItemForTheSlotEntry(slotsSection, slotEntry);
            if (item == null) {
                this.log(String.format("Item on slot entry '%s' couldn't be loaded!", slotEntry));
            }
            for (int slot : slotSet) {
                this.slots.put((short)slot, item);
            }
        }
        return true;
    }

    private Item getItemForTheSlotEntry(ConfigurationSection slotsSection, String slotEntry) {
        String itemName;
        if (slotsSection.isString(slotEntry) && (itemName = slotsSection.getString(slotEntry)).startsWith("item:")) {
            Item item = this.items.get(itemName = itemName.substring(5));
            if (item == null) {
                this.log(String.format("There is no preset item with the name '%s'!", itemName));
            }
            return item;
        }
        return Item.load(slotsSection, slotEntry);
    }

    public void update() {
        for (GUIPanelHolder panelHolder : this.inventories.values()) {
            InventoryHolder holder = panelHolder.getPlayer().getOpenInventory().getTopInventory().getHolder();
            if (holder == null || !holder.equals((Object)panelHolder)) continue;
            panelHolder.update();
        }
    }

    public void update(Player player) {
        UUID uuid = player.getUniqueId();
        GUIPanelHolder panelHolder = this.inventories.get(uuid);
        if (panelHolder == null) {
            return;
        }
        panelHolder.update();
    }

    public void open(Player player) {
        UUID uuid = player.getUniqueId();
        if (!this.inventories.containsKey(uuid)) {
            this.inventories.put(uuid, new GUIPanelHolder(this, player));
        }
        GUIPanelHolder panelHolder = this.inventories.get(uuid);
        panelHolder.open();
    }

    protected abstract void updateSpecialItems(Player var1, Inventory var2);

    public abstract void handleClickEvent(InventoryClickEvent var1);

    protected void log(String message) {
        YLogger.warn(String.format("[GUIPanel-%s] %s", this.name, message));
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public Short getRows() {
        return this.rows;
    }

    @Nullable
    public GUISound getOpenSound() {
        return this.openSound;
    }

    @Nullable
    public GUISound getCloseSound() {
        return this.closeSound;
    }

    @Nullable
    public Item getEmptySlotItem() {
        return this.items.get("empty-slot");
    }

    public HashMap<Short, Item> getSlots() {
        return this.slots;
    }

    public static void registerListeners(Plugin plugin) {
        Listener[] listeners;
        if (registered) {
            return;
        }
        registered = true;
        for (Listener listener : listeners = new Listener[]{new InventoryClickListener(), new InventoryDragListener(), new InventoryCloseListener(), new PlayerQuitListener()}) {
            Bukkit.getPluginManager().registerEvents(listener, plugin);
        }
    }

    public static void removePanelHolders(Player player) {
        for (GUIPanel panel : guiPanels.values()) {
            panel.inventories.remove(player.getUniqueId());
        }
    }

    public static boolean openPanel(String panelName, Player player) {
        GUIPanel panel = guiPanels.get(panelName);
        if (panel == null) {
            return false;
        }
        panel.open(player);
        return true;
    }
}

