/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.guis;

import java.util.HashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.GUIPanel;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.GUISound;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.Item;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.Messenger;

public class GUIPanelHolder
implements InventoryHolder {
    private final GUIPanel guiPanel;
    private final Player player;
    private final Inventory inventory;

    protected GUIPanelHolder(GUIPanel guiPanel, Player player) {
        this.guiPanel = guiPanel;
        this.player = player;
        int size = guiPanel.getRows() * 9;
        String title = guiPanel.getTitle();
        if (title == null) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size);
            this.update();
            return;
        }
        Component parsed = Messenger.parseMessage((CommandSender)player, title, null);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)parsed);
    }

    public GUIPanel getGuiPanel() {
        return this.guiPanel;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void update() {
        this.inventory.clear();
        HashMap<Short, Item> slots = this.guiPanel.getSlots();
        Item emptySlotItem = this.guiPanel.getEmptySlotItem();
        ItemStack emptySlotItemStack = new ItemStack(Material.AIR);
        if (emptySlotItem != null) {
            emptySlotItemStack = emptySlotItem.getItemStack(this.player);
        }
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            Item item = slots.get((short)i);
            if (item == null) {
                this.inventory.setItem(i, emptySlotItemStack);
                continue;
            }
            this.inventory.setItem(i, item.getItemStack(this.player));
        }
        this.guiPanel.updateSpecialItems(this.player, this.inventory);
    }

    public void open() {
        this.update();
        this.player.openInventory(this.inventory);
        GUISound openSound = this.guiPanel.getOpenSound();
        if (openSound != null) {
            openSound.playSound(this.player);
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

