/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.guis;

import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public class GUISound {
    protected String name;
    protected Sound sound;
    protected SoundCategory soundCategory = SoundCategory.MASTER;
    protected Float volume = Float.valueOf(1.0f);
    protected Float pitch = Float.valueOf(1.0f);

    public GUISound(String name) {
        this.name = name;
    }

    public boolean load(ConfigurationSection configSection) {
        if (!configSection.contains("sound")) {
            this.log("Missing key 'sound'");
            return false;
        }
        try {
            String soundString = configSection.getString("sound");
            this.sound = (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)soundString));
        }
        catch (IllegalArgumentException e) {
            this.log("Provided sound is incorrect!");
            return false;
        }
        if (configSection.contains("category")) {
            try {
                this.soundCategory = SoundCategory.valueOf((String)configSection.getString("category").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log("Provided sound category is incorrect!");
                return false;
            }
        }
        if (configSection.contains("volume")) {
            try {
                this.volume = Float.valueOf(configSection.getString("volume"));
            }
            catch (IllegalArgumentException e) {
                this.log("Provided volume is incorrect!");
                return false;
            }
        }
        if (configSection.contains("pitch")) {
            try {
                this.pitch = Float.valueOf(configSection.getString("pitch"));
            }
            catch (IllegalArgumentException e) {
                this.log("Provided pitch is incorrect!");
                return false;
            }
        }
        return true;
    }

    protected void log(String message) {
        YLogger.warn(String.format("[Sound-%s] %s", this.name, message));
    }

    public Sound sound() {
        return this.sound;
    }

    public Float volume() {
        return this.volume;
    }

    public Float pitch() {
        return this.pitch;
    }

    public void playSound(Player p) {
        p.playSound(p.getLocation(), this.sound, this.soundCategory, this.volume.floatValue(), this.pitch.floatValue());
    }
}

