/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.guis;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.ItemAction;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.Messenger;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors.ColorFormatter;

public class Item {
    protected Material material;
    protected Short amount = 1;
    protected String displayName = null;
    protected List<String> lore = new ArrayList<String>();
    protected boolean unbreakable = false;
    protected Set<ItemFlag> itemFlags = new HashSet<ItemFlag>();
    protected org.bukkit.Color potionColor = null;
    protected HashMap<Enchantment, Integer> enchantments = new HashMap();
    protected String skullOwner = null;
    private ItemStack finalItem = null;
    private ItemStack templateItem = null;
    private boolean needsComponentParsing = false;
    private final List<ItemAction> actions = new ArrayList<ItemAction>();
    private String withPermission = null;
    private Item withPermissionItem = null;

    public boolean load(ConfigurationSection config) {
        ConfigurationSection section;
        this.templateItem = null;
        if (!config.contains("material")) {
            this.log("Key 'material' is missing!");
            return false;
        }
        this.material = Material.matchMaterial((String)config.getString("material"));
        if (this.material == null || !this.material.isItem()) {
            this.log(String.format("Material '%s' is incorrect!", config.getString("material")));
            return false;
        }
        if (config.contains("amount")) {
            this.amount = (short)config.getInt("amount");
            if (this.amount <= 0) {
                this.log("Amount can't be lower than 0! It will be set to 1.");
                this.amount = 1;
            }
        }
        if (config.contains("display-name")) {
            this.displayName = config.getString("display-name");
        }
        if (config.contains("lore")) {
            if (!config.isList("lore")) {
                this.log("Lore must be a list!");
                return false;
            }
            this.lore = config.getStringList("lore");
        }
        if (config.contains("unbreakable")) {
            this.unbreakable = config.getBoolean("unbreakable");
        }
        if (config.contains("item-flags")) {
            if (!config.isList("item-flags")) {
                this.log("Item-flags must be a list!");
                return false;
            }
            List flags = config.getStringList("item-flags");
            for (String flag : flags) {
                try {
                    ItemFlag itemFlag = ItemFlag.valueOf((String)flag.toUpperCase());
                    this.itemFlags.add(itemFlag);
                }
                catch (IllegalArgumentException e) {
                    this.log(String.format("Item flag '%s' is incorrect!", flag));
                }
            }
        }
        if (config.contains("potion-color")) {
            String hexColor = config.getString("potion-color");
            try {
                Color c = Color.decode(hexColor);
                this.potionColor = org.bukkit.Color.fromRGB((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
            }
            catch (NumberFormatException e) {
                this.log(String.format("Potion color '%s' is incorrect! It's supposed to be in the HEX format - #RRGGBB.", hexColor));
            }
        }
        if (config.contains("skull-owner")) {
            this.skullOwner = config.getString("skull-owner");
            if (!this.material.equals((Object)Material.PLAYER_HEAD)) {
                this.log("Skull owner field is set but item material isn't a player head!");
            }
        }
        if (config.isConfigurationSection("actions")) {
            section = config.getConfigurationSection("actions");
            Set keys = section.getKeys(false);
            for (String key : keys) {
                if (!section.isConfigurationSection(key)) continue;
                ItemAction action = new ItemAction(this);
                ConfigurationSection actionSection = section.getConfigurationSection(key);
                if (!action.load(actionSection)) {
                    this.log(String.format("Couldn't load '%s' action!", key));
                    continue;
                }
                this.actions.add(action);
            }
        }
        if (config.isConfigurationSection("with-permission")) {
            section = config.getConfigurationSection("with-permission");
            this.withPermission = section.getString("permission");
            if (this.withPermission == null) {
                this.log("'with-permission' section has to have 'permission' field!");
                return false;
            }
            ConfigurationSection itemSection = section.getConfigurationSection("item");
            if (itemSection == null) {
                this.log("'with-permission' section has to have 'item' section!");
                return false;
            }
            config.set("with-permission", null);
            for (String key : itemSection.getKeys(false)) {
                config.set(key, itemSection.get(key));
            }
            this.withPermissionItem = new Item();
            if (!this.withPermissionItem.load(config)) {
                this.log("With-permission item couldn't be loaded!");
                return false;
            }
        }
        this.setupItemStacks(config);
        return true;
    }

    public static Item load(ConfigurationSection config, String key) {
        Item item = new Item();
        ConfigurationSection section = config.getConfigurationSection(key);
        if (section == null) {
            String material = config.getString(key);
            Material mat = Material.matchMaterial((String)material);
            if (mat == null || !mat.isItem()) {
                item.log(String.format("Material '%s' is incorrect!", material));
                return null;
            }
            item.material = mat;
            item.setupItemStacks(null);
            return item;
        }
        return item.load(section) ? item : null;
    }

    protected void log(String message) {
        YLogger.warn(String.format("[Item] %s", message));
    }

    private void setupItemStacks(ConfigurationSection config) {
        if (this.material.isAir()) {
            this.finalItem = this.templateItem = new ItemStack(Material.AIR);
            return;
        }
        MiniMessage serializer = ColorFormatter.SERIALIZER;
        this.templateItem = new ItemStack(this.material, (int)this.amount.shortValue());
        ItemMeta meta = this.templateItem.getItemMeta();
        meta.setUnbreakable(this.unbreakable);
        for (ItemFlag flag : this.itemFlags) {
            meta.addItemFlags(new ItemFlag[]{flag});
        }
        for (Enchantment enchant : this.enchantments.keySet()) {
            meta.addEnchant(enchant, this.enchantments.get(enchant).intValue(), true);
        }
        if (this.potionColor != null) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(this.potionColor);
        }
        this.templateItem.setItemMeta(meta);
        this.finalItem = this.templateItem.clone();
        meta = this.finalItem.getItemMeta();
        if (this.displayName != null) {
            this.needsComponentParsing = true;
            Component displayName = serializer.deserialize((Object)this.displayName);
            meta.displayName(ColorFormatter.negateUnsetDecoration(displayName, TextDecoration.ITALIC));
        }
        if (!this.lore.isEmpty()) {
            this.needsComponentParsing = true;
            ArrayList<Component> lore = new ArrayList<Component>();
            for (String line : this.lore) {
                Component parsed = serializer.deserialize((Object)line);
                lore.add(ColorFormatter.negateUnsetDecoration(parsed, TextDecoration.ITALIC));
            }
            meta.lore(lore);
        }
        if (this.material.equals((Object)Material.PLAYER_HEAD) && this.skullOwner != null) {
            this.needsComponentParsing = true;
        }
        this.finalItem.setItemMeta(meta);
    }

    public ItemStack getItemStack() {
        return this.finalItem;
    }

    public ItemStack getItemStack(Player player) {
        return this.getItemStack(player, new HashMap<String, Object>());
    }

    public ItemStack getItemStack(Player player, HashMap<String, Object> placeholders) {
        if (this.withPermission != null && player.hasPermission(this.withPermission)) {
            return this.withPermissionItem.getItemStack(player, placeholders);
        }
        if (!this.needsComponentParsing) {
            return this.templateItem;
        }
        if (placeholders != null) {
            placeholders.put("player-name", player.getName());
            placeholders.put("player-uuid", player.getUniqueId().toString());
        }
        ItemStack item = this.templateItem.clone();
        ItemMeta meta = item.getItemMeta();
        if (this.displayName != null) {
            Component displayName = Messenger.parseMessage((CommandSender)player, this.displayName, placeholders);
            meta.displayName(ColorFormatter.negateUnsetDecoration(displayName, TextDecoration.ITALIC));
        }
        if (!this.lore.isEmpty()) {
            ArrayList<Component> lore = new ArrayList<Component>();
            for (String line : this.lore) {
                Component parsed = Messenger.parseMessage((CommandSender)player, line, placeholders);
                lore.add(ColorFormatter.negateUnsetDecoration(parsed, TextDecoration.ITALIC));
            }
            meta.lore(lore);
        }
        if (this.material.equals((Object)Material.PLAYER_HEAD) && this.skullOwner != null) {
            String owner = Messenger.parsePluginPlaceholders(this.skullOwner, placeholders);
            owner = ColorFormatter.parsePAPI((CommandSender)player, owner);
            try {
                PlayerProfile profile = Bukkit.createProfile((String)owner);
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setPlayerProfile(profile);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                this.log(String.format("Provided skull-owner is incorrect! ('%s')", owner));
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public void performActions(InventoryClickEvent event) {
        for (ItemAction action : this.actions) {
            action.performAction(event);
        }
    }
}

