/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.guis;

import java.util.HashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.GUIPanel;
import pl.ynfuien.yupdatechecker.libs.ydevlib.guis.Item;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.Messenger;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;
import pl.ynfuien.yupdatechecker.libs.ydevlib.utils.CommonPlaceholders;

public class ItemAction {
    private final Item item;
    private ClickType clickType = null;
    private boolean shift = false;
    private String playerCommand = null;
    private String consoleCommand = null;
    private boolean closeGui = false;
    private String openGui = null;

    public ItemAction(Item item) {
        this.item = item;
    }

    public boolean load(ConfigurationSection config) {
        String click = config.getString("condition.click");
        if (click == null) {
            this.log("There is no click type provided!");
            return false;
        }
        this.shift = config.getBoolean("condition.shift");
        if (click.equalsIgnoreCase("left")) {
            this.clickType = this.shift ? ClickType.SHIFT_LEFT : ClickType.LEFT;
        } else if (click.equalsIgnoreCase("right")) {
            this.clickType = this.shift ? ClickType.SHIFT_RIGHT : ClickType.RIGHT;
        } else if (click.equalsIgnoreCase("middle")) {
            this.clickType = ClickType.MIDDLE;
        } else {
            this.log(String.format("Click type '%s' is incorrect!", click));
            return false;
        }
        ConfigurationSection resultSection = config.getConfigurationSection("result");
        this.playerCommand = resultSection.getString("player-command");
        this.consoleCommand = resultSection.getString("console-command");
        this.closeGui = resultSection.getBoolean("close-gui");
        this.openGui = resultSection.getString("open-gui");
        if (this.playerCommand.isBlank()) {
            this.playerCommand = null;
        }
        if (this.consoleCommand.isBlank()) {
            this.consoleCommand = null;
        }
        return true;
    }

    protected void log(String message) {
        YLogger.warn(String.format("[Item-Action] %s", message));
    }

    public void performAction(InventoryClickEvent event) {
        if (!event.getClick().equals((Object)this.clickType)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        CommonPlaceholders.setPlayer(placeholders, (OfflinePlayer)player);
        if (this.playerCommand != null) {
            player.performCommand(Messenger.parsePluginPlaceholdersAndPAPI(player, this.playerCommand, placeholders));
        }
        if (this.consoleCommand != null) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)Messenger.parsePluginPlaceholdersAndPAPI(player, this.consoleCommand, placeholders));
        }
        if (this.closeGui) {
            player.closeInventory();
        }
        if (this.openGui != null) {
            GUIPanel.openPanel(this.openGui, player);
        }
    }

    public Item getItem() {
        return this.item;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public boolean isShift() {
        return this.shift;
    }

    @Nullable
    public String getPlayerCommand() {
        return this.playerCommand;
    }

    @Nullable
    public String getConsoleCommand() {
        return this.consoleCommand;
    }

    public boolean isCloseGui() {
        return this.closeGui;
    }

    @Nullable
    public String getOpenGui() {
        return this.openGui;
    }
}

