/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.messages;

import java.util.HashMap;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.Nullable;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.Messenger;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.YLogger;

public abstract class LangBase {
    private static FileConfiguration langConfig;

    public static void loadLang(FileConfiguration langConfig) {
        LangBase.langConfig = langConfig;
    }

    @Nullable
    public static String get(String path) {
        return langConfig.getString(path);
    }

    @Nullable
    public static String get(String path, HashMap<String, Object> placeholders) {
        placeholders.put("prefix", LangBase.get("prefix"));
        return Messenger.parsePluginPlaceholders(langConfig.getString(path), placeholders);
    }

    public static void sendMessage(CommandSender sender, Message message, HashMap<String, Object> placeholders) {
        String path = message.getName();
        if (!langConfig.isSet(path)) {
            YLogger.error(String.format("There is no message '%s'!", path));
            return;
        }
        List<String> messages = langConfig.isList(path) ? langConfig.getStringList(path) : List.of(langConfig.getString(path));
        if (placeholders == null) {
            placeholders = new HashMap();
        }
        placeholders.put("prefix", LangBase.get("prefix"));
        for (String msg : messages) {
            if (msg.isEmpty()) continue;
            Messenger.send(sender, msg, placeholders);
        }
    }

    public static interface Message {
        public String getName();
    }
}

