/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.messages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors.ColorFormatter;

public class Messenger {
    private static final Pattern PLUGIN_PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    private static final Pattern PLUGIN_PLACEHOLDER_FLAGS_PATTERN = Pattern.compile("(?<=[{])[!@#]+(?=([^{}]+)[}])");

    public static void send(CommandSender receiver, String message) {
        message = message.replace('\u00a7', '&');
        Component formatted = ColorFormatter.SERIALIZER.deserialize((Object)(message = ColorFormatter.parsePAPI(receiver, message)));
        if (formatted.equals((Object)Component.empty())) {
            return;
        }
        receiver.sendMessage(formatted);
    }

    public static void send(CommandSender receiver, String message, HashMap<String, Object> placeholders) {
        if (receiver == null) {
            return;
        }
        if (message == null) {
            return;
        }
        Component formatted = Messenger.parseMessage(receiver, message, placeholders);
        if (formatted.equals((Object)Component.empty())) {
            return;
        }
        receiver.sendMessage(formatted);
    }

    public static Component parseMessage(CommandSender sender, String message, HashMap<String, Object> placeholders) {
        String value;
        Set<PluginPlaceholder> usedPlaceholders = Messenger.getUsedPlaceholders(message, placeholders);
        HashSet<PluginPlaceholder> replaced = new HashSet<PluginPlaceholder>();
        for (PluginPlaceholder placeholder : usedPlaceholders) {
            if (placeholder.isFlagNoFormatting() || placeholder.isFlagNoPAPI()) continue;
            value = placeholder.value();
            message = message.replace(placeholder.exactMatch(), value);
            replaced.add(placeholder);
        }
        usedPlaceholders.removeAll(replaced);
        replaced.clear();
        message = message.replace('\u00a7', '&');
        message = ColorFormatter.parsePAPI(sender, message);
        for (PluginPlaceholder placeholder : usedPlaceholders) {
            if (!placeholder.isFlagNoPAPI()) continue;
            value = placeholder.value();
            message = message.replace(placeholder.exactMatch(), value);
            replaced.add(placeholder);
        }
        usedPlaceholders.removeAll(replaced);
        replaced.clear();
        Component formatted = MiniMessage.miniMessage().deserialize((Object)message);
        for (PluginPlaceholder placeholder : usedPlaceholders) {
            String value2 = placeholder.value();
            TextComponent unformattedValue = Component.text((String)value2);
            TextReplacementConfig replacement = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(placeholder.exactMatch()).replacement((ComponentLike)unformattedValue).build();
            formatted = formatted.replaceText(replacement);
        }
        return formatted;
    }

    public static String parsePluginPlaceholders(String text, HashMap<String, Object> placeholders) {
        if (text == null) {
            return null;
        }
        if (text.isBlank()) {
            return text;
        }
        if (placeholders.isEmpty()) {
            return text;
        }
        Set<PluginPlaceholder> usedPlaceholders = Messenger.getUsedPlaceholders(text, placeholders);
        if (usedPlaceholders.isEmpty()) {
            return text;
        }
        for (PluginPlaceholder placeholder : usedPlaceholders) {
            if (placeholder.isFlagNoFormatting() || placeholder.isFlagNoPAPI()) continue;
            String value = placeholder.value();
            text = text.replace(placeholder.exactMatch(), value);
        }
        return text;
    }

    public static String parsePluginPlaceholdersAndPAPI(Player player, String text, HashMap<String, Object> placeholders) {
        return ColorFormatter.parsePAPI((CommandSender)player, Messenger.parsePluginPlaceholders(text, placeholders));
    }

    private static Set<PluginPlaceholder> getUsedPlaceholders(String text, HashMap<String, Object> placeholders) {
        HashSet<PluginPlaceholder> usedPlaceholders = new HashSet<PluginPlaceholder>();
        if (text == null) {
            return usedPlaceholders;
        }
        if (text.isBlank()) {
            return usedPlaceholders;
        }
        if (placeholders == null) {
            return usedPlaceholders;
        }
        if (placeholders.isEmpty()) {
            return usedPlaceholders;
        }
        Matcher matcher = PLUGIN_PLACEHOLDER_PATTERN.matcher(text);
        while (matcher.find()) {
            String match = matcher.group();
            PluginPlaceholder placeholder = new PluginPlaceholder(match);
            Object value = placeholders.get(placeholder.name());
            if (value == null) continue;
            placeholder.setValue(value);
            usedPlaceholders.add(placeholder);
        }
        return usedPlaceholders;
    }

    private static class PluginPlaceholder {
        private final String exactMatch;
        private final String name;
        private final Set<PlaceholderFlag> flags = new HashSet<PlaceholderFlag>();
        private String value = null;

        public PluginPlaceholder(String placeholder) {
            this.exactMatch = placeholder;
            Matcher matcher = PLUGIN_PLACEHOLDER_FLAGS_PATTERN.matcher(placeholder);
            if (!matcher.find()) {
                this.name = placeholder.substring(1, placeholder.length() - 1);
                return;
            }
            String match = matcher.group();
            for (PlaceholderFlag flag : PlaceholderFlag.values()) {
                if (!match.contains(String.valueOf(flag.flagChar()))) continue;
                this.flags.add(flag);
            }
            this.name = placeholder.substring(1 + match.length(), placeholder.length() - 1);
        }

        public String exactMatch() {
            return this.exactMatch;
        }

        public String name() {
            return this.name;
        }

        public Set<PlaceholderFlag> flags() {
            return this.flags;
        }

        public String value() {
            return this.value;
        }

        public boolean isFlagNoPAPI() {
            return this.flags.contains((Object)PlaceholderFlag.NO_PAPI);
        }

        public boolean isFlagNoFormatting() {
            return this.flags.contains((Object)PlaceholderFlag.NO_FORMATTING);
        }

        public boolean isFlagEscapeQuotes() {
            return this.flags.contains((Object)PlaceholderFlag.ESCAPE_QUOTES);
        }

        public void setValue(Object value) {
            this.value = value.toString();
            if (this.isFlagEscapeQuotes()) {
                this.value = this.value.replace("\"", "\\\"");
            }
        }
    }

    private static enum PlaceholderFlag {
        NO_FORMATTING('!'),
        NO_PAPI('@'),
        ESCAPE_QUOTES('#');

        private final char flagChar;

        private PlaceholderFlag(char flagChar) {
            this.flagChar = flagChar;
        }

        public char flagChar() {
            return this.flagChar;
        }
    }
}

