/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.util.Index;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors.HexColorTagResolver;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors.LegacyPostProcessor;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors.SingleColorTagResolver;

public class ColorFormatter {
    public static final MiniMessage SERIALIZER = MiniMessage.builder().postProcessor((UnaryOperator)new LegacyPostProcessor()).build();
    public static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexCharacter('#').hexColors().build();
    private static boolean PAPI_ENABLED = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    private final HashMap<String, TagResolver> tagResolvers;
    private final String permissionBase;
    private static final Pattern MM_TAG_PATTERN = Pattern.compile("<.+>");

    public ColorFormatter(String permissionBase, Set<YTagResolver> excluded) {
        this.permissionBase = permissionBase;
        this.tagResolvers = ColorFormatter.createTagResolverMapByPermission(permissionBase, excluded);
    }

    public ColorFormatter(String permissionBase) {
        this.permissionBase = permissionBase;
        this.tagResolvers = ColorFormatter.createTagResolverMapByPermission(permissionBase, Set.of(YTagResolver.CLICK, YTagResolver.HOVER, YTagResolver.INSERTION, YTagResolver.NEWLINE));
    }

    public static HashMap<String, TagResolver> createTagResolverMapByPermission(String permissionBase, Set<YTagResolver> excludedResolvers) {
        HashMap<String, TagResolver> tagResolvers = new HashMap<String, TagResolver>();
        for (YTagResolver yResolver : YTagResolver.values()) {
            if (excludedResolvers.contains((Object)yResolver)) continue;
            tagResolvers.put(yResolver.getPermission(permissionBase), yResolver.getResolver());
        }
        Index colorsIndex = NamedTextColor.NAMES;
        for (String colorName : colorsIndex.keys()) {
            tagResolvers.put(String.format("%s.color.%s", permissionBase, colorName), SingleColorTagResolver.of((NamedTextColor)colorsIndex.value((Object)colorName)));
        }
        for (TextDecoration decoration : TextDecoration.values()) {
            tagResolvers.put(String.format("%s.decoration.%s", permissionBase, decoration.name()), StandardTags.decorations((TextDecoration)decoration));
        }
        return tagResolvers;
    }

    public Component format(CommandSender p, String text) {
        return this.format(p, text, true);
    }

    public Component format(CommandSender p, String text, boolean usePapi) {
        if (usePapi && p.hasPermission(this.permissionBase + ".papi")) {
            text = ColorFormatter.parsePAPI(p, text);
        }
        return this.parseFormats(p, text);
    }

    public static String parsePAPI(CommandSender sender, String message) {
        if (message == null) {
            return null;
        }
        if (message.isBlank()) {
            return message;
        }
        if (!PAPI_ENABLED) {
            return message;
        }
        if (!(sender instanceof Player)) {
            return message;
        }
        Player p = (Player)sender;
        if (!PlaceholderAPI.containsPlaceholders((String)message)) {
            return message;
        }
        Matcher matcher = PlaceholderAPI.getPlaceholderPattern().matcher(message);
        while (matcher.find()) {
            String parsed;
            String match = matcher.group();
            if (match.equals(parsed = PlaceholderAPI.setPlaceholders((Player)p, (String)match))) continue;
            parsed = parsed.replace('\u00a7', '&');
            String formatted = (String)MiniMessage.miniMessage().serialize(SERIALIZER.deserialize((Object)parsed));
            message = message.replace(match, formatted);
        }
        return message;
    }

    private Component parseFormats(CommandSender p, String message) {
        MiniMessage serializer = MiniMessage.builder().postProcessor((UnaryOperator)new LegacyPostProcessor((Permissible)p, this.permissionBase)).tags(TagResolver.empty()).build();
        if (!MM_TAG_PATTERN.matcher(message).find()) {
            return serializer.deserialize((Object)message);
        }
        ArrayList<TagResolver> permittedResolvers = new ArrayList<TagResolver>();
        for (String perm : this.tagResolvers.keySet()) {
            if (!p.hasPermission(perm)) continue;
            permittedResolvers.add(this.tagResolvers.get(perm));
        }
        return serializer.deserialize(message, TagResolver.resolver(permittedResolvers));
    }

    public static Component negateUnsetDecoration(Component component, TextDecoration decoration) {
        ArrayList children = new ArrayList(component.children());
        children.replaceAll(component1 -> ColorFormatter.negateUnsetDecoration(component1, decoration));
        TextDecoration.State state = component.decoration(decoration);
        if (state.equals((Object)TextDecoration.State.NOT_SET) && component.color() != null) {
            component = component.decoration(decoration, TextDecoration.State.FALSE);
        }
        return component.children(children);
    }

    public static enum YTagResolver {
        COLOR_HEX(HexColorTagResolver.get()),
        CLICK(StandardTags.clickEvent()),
        FONT(StandardTags.font()),
        GRADIENT(StandardTags.gradient()),
        HOVER(StandardTags.hoverEvent()),
        INSERTION(StandardTags.insertion()),
        KEYBIND(StandardTags.keybind()),
        NEWLINE(StandardTags.newline()),
        RAINBOW(StandardTags.rainbow()),
        RESET(StandardTags.reset()),
        SELECTOR(StandardTags.selector()),
        TRANSITION(StandardTags.transition()),
        TRANSLATABLE(StandardTags.translatable()),
        SHADOW_COLOR(StandardTags.shadowColor()),
        PRIDE(StandardTags.pride()),
        SPRITE(StandardTags.sprite()),
        HEAD(StandardTags.sequentialHead());

        private final TagResolver resolver;

        private YTagResolver(TagResolver resolver) {
            this.resolver = resolver;
        }

        public TagResolver getResolver() {
            return this.resolver;
        }

        public String getName() {
            return this.name().toLowerCase().replace('_', '.');
        }

        public String getPermission(String base) {
            return base + "." + this.getName();
        }
    }
}

