/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors;

import java.util.Set;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HexColorTagResolver
implements TagResolver,
SerializableResolver.Single {
    private static final char HEX = '#';
    private static final String TAG_NAME = "color";
    private static final Set<String> ALIASES = Set.of("colour", "c");
    private static final StyleClaim<TextColor> STYLE = StyleClaim.claim((String)"color", Style::color, (color, emitter) -> emitter.tag(color.asHexString()));
    private static final HexColorTagResolver INSTANCE = new HexColorTagResolver();

    private static boolean isColorOrAbbreviation(String name) {
        return name.equals(TAG_NAME) || ALIASES.contains(name);
    }

    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue args, @NotNull Context ctx) throws ParsingException {
        if (!this.has(name)) {
            return null;
        }
        String colorName = name;
        if (HexColorTagResolver.isColorOrAbbreviation(name)) {
            colorName = args.popOr("Expected to find a color parameter: #RRGGBB").lowerValue();
        }
        TextColor color = HexColorTagResolver.resolveColor(colorName, ctx);
        return Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{color});
    }

    @NotNull
    static TextColor resolveColor(@NotNull String colorName, @NotNull Context ctx) throws ParsingException {
        if (colorName.charAt(0) == '#') {
            return TextColor.fromHexString((String)colorName);
        }
        throw ctx.newException(String.format("Unable to parse a color from '%s'. Please use hex (#RRGGBB) colors.", colorName));
    }

    public boolean has(@NotNull String name) {
        return HexColorTagResolver.isColorOrAbbreviation(name) || TextColor.fromHexString((String)name) != null;
    }

    @Nullable
    public StyleClaim<?> claimStyle() {
        return STYLE;
    }

    public static HexColorTagResolver get() {
        return INSTANCE;
    }
}

