/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors;

import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.permissions.Permissible;

public final class LegacyPostProcessor
implements UnaryOperator<Component> {
    private Permissible player = null;
    private String permissionBase = null;
    public static final HashMap<ChatColor, String> LEGACY_FORMATS = new HashMap();
    private final Replacer REPLACER = new Replacer();
    private static final Pattern LEGACY_PATTERN;
    private static final Pattern LEGACY_HEX_PATTERN;
    private static final String SECTION_CHAR = "\u00a7";

    public LegacyPostProcessor(Permissible player, String permissionBase) {
        this.player = player;
        this.permissionBase = permissionBase;
    }

    public LegacyPostProcessor() {
    }

    @Override
    public Component apply(Component component) {
        return component.replaceText((Consumer)this.REPLACER);
    }

    private static String parseLegacyFormats(Permissible p, String message, String permissionBase) {
        String match;
        Matcher matcher;
        if (p.hasPermission(permissionBase + ".legacy.hex")) {
            matcher = LEGACY_HEX_PATTERN.matcher(message);
            while (matcher.find()) {
                match = matcher.group();
                message = message.replace(match, SECTION_CHAR + match.substring(1));
            }
        }
        matcher = LEGACY_PATTERN.matcher(message);
        while (matcher.find()) {
            match = matcher.group();
            char colorChar = Character.toLowerCase(match.charAt(1));
            ChatColor color = ChatColor.getByChar((char)colorChar);
            if (!p.hasPermission(permissionBase + LEGACY_FORMATS.get(color))) continue;
            message = message.replace(match, SECTION_CHAR + colorChar);
        }
        return message;
    }

    static {
        for (ChatColor color : ChatColor.values()) {
            LEGACY_FORMATS.put(color, ".legacy." + color.name().toLowerCase());
        }
        LEGACY_PATTERN = Pattern.compile("&[0-9a-fA-Fk-oK-OrR]");
        LEGACY_HEX_PATTERN = Pattern.compile("&#[0-9a-fA-F]{6}");
    }

    private final class Replacer
    implements Consumer<TextReplacementConfig.Builder> {
        private final Replacement REPLACEMENT;
        private static final Pattern PATTERN_ANY = Pattern.compile(".*");

        private Replacer() {
            this.REPLACEMENT = new Replacement();
        }

        @Override
        public void accept(TextReplacementConfig.Builder builder) {
            builder.match(PATTERN_ANY).replacement((BiFunction)this.REPLACEMENT);
        }
    }

    private final class Replacement
    implements BiFunction<MatchResult, TextComponent.Builder, ComponentLike> {
        private Replacement() {
        }

        @Override
        public ComponentLike apply(MatchResult matchResult, TextComponent.Builder builder) {
            String match = matchResult.group();
            if (!match.contains("&")) {
                return Component.text((String)match);
            }
            if (LegacyPostProcessor.this.player == null) {
                return LegacyComponentSerializer.legacyAmpersand().deserialize(match);
            }
            match = LegacyPostProcessor.parseLegacyFormats(LegacyPostProcessor.this.player, match, LegacyPostProcessor.this.permissionBase);
            return LegacyComponentSerializer.legacySection().deserialize(match);
        }
    }
}

