/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleColorTagResolver
implements TagResolver,
SerializableResolver.Single {
    private static final String TAG_NAME = "color";
    private static final Set<String> ALIASES = Set.of("colour", "c");
    private static final StyleClaim<TextColor> STYLE = StyleClaim.claim((String)"color", Style::color, (color, emitter) -> {
        if (color instanceof NamedTextColor) {
            emitter.tag((String)NamedTextColor.NAMES.key((Object)((NamedTextColor)color)));
        }
    });
    private static final Map<String, TextColor> COLOR_ALIASES = new HashMap<String, TextColor>();
    private final NamedTextColor allowedColor;

    private static boolean isColorOrAbbreviation(String name) {
        return name.equals(TAG_NAME) || ALIASES.contains(name);
    }

    public SingleColorTagResolver(NamedTextColor color) {
        this.allowedColor = color;
    }

    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue args, @NotNull Context ctx) throws ParsingException {
        TextColor color;
        if (!this.has(name)) {
            return null;
        }
        String colorName = name;
        if (SingleColorTagResolver.isColorOrAbbreviation(name)) {
            colorName = args.popOr("Expected to find a color parameter: <name>|#RRGGBB").lowerValue();
        }
        if (!this.allowedColor.equals(color = SingleColorTagResolver.resolveColor(colorName, ctx))) {
            return null;
        }
        return Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{color});
    }

    @NotNull
    static TextColor resolveColor(@NotNull String colorName, @NotNull Context ctx) throws ParsingException {
        if (COLOR_ALIASES.containsKey(colorName)) {
            return COLOR_ALIASES.get(colorName);
        }
        TextColor color = (TextColor)NamedTextColor.NAMES.value((Object)colorName);
        if (color != null) {
            return color;
        }
        throw ctx.newException(String.format("Unable to parse a color from '%s'. Please use named colours or hex (#RRGGBB) colors.", colorName));
    }

    public boolean has(@NotNull String name) {
        return SingleColorTagResolver.isColorOrAbbreviation(name) || NamedTextColor.NAMES.value((Object)name) != null || COLOR_ALIASES.containsKey(name);
    }

    @Nullable
    public StyleClaim<?> claimStyle() {
        return STYLE;
    }

    public static SingleColorTagResolver of(NamedTextColor color) {
        return new SingleColorTagResolver(color);
    }

    static {
        COLOR_ALIASES.put("dark_grey", (TextColor)NamedTextColor.DARK_GRAY);
        COLOR_ALIASES.put("grey", (TextColor)NamedTextColor.GRAY);
    }
}

