/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.utils;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import pl.ynfuien.yupdatechecker.libs.ydevlib.messages.colors.ColorFormatter;
import pl.ynfuien.yupdatechecker.libs.ydevlib.utils.DoubleFormatter;

public class CommonPlaceholders {
    private static final DoubleFormatter df = new DoubleFormatter();

    public static void setLocation(HashMap<String, Object> placeholders, Location loc) {
        CommonPlaceholders.setLocation(placeholders, loc, null);
    }

    public static void setLocation(HashMap<String, Object> placeholders, Location loc, String prefix) {
        Object pfx = prefix == null ? "" : prefix + "-";
        placeholders.put((String)pfx + "x", df.format(loc.getX()));
        placeholders.put((String)pfx + "y", df.format(loc.getY()));
        placeholders.put((String)pfx + "z", df.format(loc.getZ()));
        placeholders.put((String)pfx + "yaw", df.format(loc.getYaw()));
        placeholders.put((String)pfx + "pitch", df.format(loc.getPitch()));
        World world = loc.getWorld();
        placeholders.put((String)pfx + "world", world != null ? world.getName() : "undefined");
    }

    public static void setDateTime(HashMap<String, Object> placeholders, long timestamp, String prefix) {
        Object pfx = prefix == null ? "" : prefix + "-";
        LocalDateTime date = new Timestamp(timestamp).toLocalDateTime();
        placeholders.put((String)pfx + "year", date.getYear());
        placeholders.put((String)pfx + "month", String.format("%02d", date.getMonthValue()));
        placeholders.put((String)pfx + "day", String.format("%02d", date.getDayOfMonth()));
        placeholders.put((String)pfx + "hour", String.format("%02d", date.getHour()));
        placeholders.put((String)pfx + "minute", String.format("%02d", date.getMinute()));
        placeholders.put((String)pfx + "second", String.format("%02d", date.getSecond()));
    }

    public static void setDuration(HashMap<String, Object> placeholders, long time, String prefix) {
        Duration duration = Duration.ofMillis(time);
        CommonPlaceholders.setDuration(placeholders, duration, prefix);
    }

    public static void setDuration(HashMap<String, Object> placeholders, Duration duration, String prefix) {
        Object pfx = prefix == null ? "" : prefix + "-";
        placeholders.put((String)pfx + "days", duration.toDaysPart());
        placeholders.put((String)pfx + "hours", duration.toHoursPart());
        placeholders.put((String)pfx + "minutes", duration.toMinutesPart());
        placeholders.put((String)pfx + "seconds", duration.toSecondsPart());
        placeholders.put((String)pfx + "milliseconds", duration.toMillisPart());
    }

    public static void setPlayer(HashMap<String, Object> placeholders, OfflinePlayer player) {
        CommonPlaceholders.setPlayer(placeholders, player, null);
    }

    public static void setPlayer(HashMap<String, Object> placeholders, OfflinePlayer player, String prefix) {
        Object pfx = prefix == null ? "" : prefix + "-";
        placeholders.put((String)pfx + "player-uuid", player.getUniqueId());
        placeholders.put((String)pfx + "player-username", player.getName());
        placeholders.put((String)pfx + "player-name", player.getName());
        if (player.isOnline()) {
            placeholders.put((String)pfx + "player-display-name", ColorFormatter.SERIALIZER.serialize(player.getPlayer().displayName()));
        }
    }

    public static void setEntity(HashMap<String, Object> placeholders, Entity entity) {
        CommonPlaceholders.setEntity(placeholders, entity, null);
    }

    public static void setEntity(HashMap<String, Object> placeholders, Entity entity, String prefix) {
        Object pfx = prefix == null ? "" : prefix + "-";
        placeholders.put((String)pfx + "uuid", entity.getUniqueId());
        placeholders.put((String)pfx + "name", ColorFormatter.SERIALIZER.serialize(entity.name()));
        placeholders.put((String)pfx + "type", entity.getType().name());
    }
}

