/*
 * Decompiled with CFR 0.152.
 */
package pl.ynfuien.yupdatechecker.libs.ydevlib.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DoubleFormatter {
    public static final DoubleFormatter DEFAULT = new DoubleFormatter();
    private boolean cutDecimalZeros;
    private int exactDecimalPlaces;
    private int maxDecimalPlaces = -1;
    private final DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.getDefault());

    public DoubleFormatter() {
        this.cutDecimalZeros = true;
        this.exactDecimalPlaces = 2;
    }

    public DoubleFormatter(boolean cutDecimalZeros, int exactDecimalPlaces) {
        this.cutDecimalZeros = cutDecimalZeros;
        this.exactDecimalPlaces = Math.max(exactDecimalPlaces, 0);
    }

    public DoubleFormatter cutDecimalZeros(boolean cut) {
        this.cutDecimalZeros = cut;
        return this;
    }

    public DoubleFormatter setExactDecimalPlaces(int places) {
        this.maxDecimalPlaces = -1;
        this.exactDecimalPlaces = Math.max(places, 0);
        return this;
    }

    public DoubleFormatter setMaxDecimalPlaces(int places) {
        this.exactDecimalPlaces = -1;
        this.maxDecimalPlaces = Math.max(places, 0);
        return this;
    }

    public DoubleFormatter setDecimalSeparator(char separator) {
        this.formatSymbols.setDecimalSeparator(separator);
        return this;
    }

    public String format(double number) {
        if (this.cutDecimalZeros && (double)((int)number) == number) {
            return Integer.toString((int)number);
        }
        if (this.exactDecimalPlaces == -1 && this.maxDecimalPlaces == -1) {
            return Double.toString(number);
        }
        if (this.exactDecimalPlaces == 0 || this.maxDecimalPlaces == 0) {
            return Integer.toString((int)number);
        }
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(this.formatSymbols);
        if (this.exactDecimalPlaces != -1) {
            df.applyPattern("0." + "0".repeat(this.exactDecimalPlaces));
            return df.format(number);
        }
        df.applyPattern("#." + "#".repeat(this.maxDecimalPlaces));
        return df.format(number);
    }
}

