/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    public boolean ShowWarningTooltipsOnItems;

    public static ClientConfig create() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("cookyourfood-client.json");
        ConfigInner loaded = null;
        if (configPath.toFile().exists()) {
            try {
                Gson gson = new Gson();
                loaded = (ConfigInner)gson.fromJson(Files.readString(configPath), ConfigInner.class);
            }
            catch (IOException gson) {
                // empty catch block
            }
        }
        if (loaded == null) {
            loaded = new ConfigInner();
        }
        ClientConfig result = new ClientConfig();
        result.ShowWarningTooltipsOnItems = loaded.show_warning_tooltips_on_items;
        if (!configPath.toFile().exists()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String text = gson.toJson((Object)loaded, ConfigInner.class);
                Files.writeString(configPath, (CharSequence)text, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private ClientConfig() {
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigInner {
        public String comment = "Show warning tooltips on items that would cause food poisoning.";
        public boolean show_warning_tooltips_on_items = true;

        private ConfigInner() {
        }
    }
}

