/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;

public class CommonConfig {
    public double EasyDifDurationMultiplier;
    public double NormalDifDurationMultiplier;
    public double HardDifDurationMultiplier;

    public static CommonConfig create() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("cookyourfood-common.json");
        ConfigInner loaded = null;
        if (configPath.toFile().exists()) {
            try {
                Gson gson = new Gson();
                loaded = (ConfigInner)gson.fromJson(Files.readString(configPath), ConfigInner.class);
            }
            catch (IOException gson) {
                // empty catch block
            }
        }
        if (loaded == null) {
            loaded = new ConfigInner();
        }
        CommonConfig result = new CommonConfig();
        result.EasyDifDurationMultiplier = loaded.easy_dif_duration_multiplier;
        result.NormalDifDurationMultiplier = loaded.normal_dif_duration_multiplier;
        result.HardDifDurationMultiplier = loaded.hard_dif_duration_multiplier;
        if (!configPath.toFile().exists()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String text = gson.toJson((Object)loaded, ConfigInner.class);
                Files.writeString(configPath, (CharSequence)text, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private CommonConfig() {
    }

    private static class ConfigInner {
        public String comment = "This is the multiplier which can shorten or lengthen potion effect durations, when you earn them by eating raw food. Default value of 1.0 means author-designed durations.";
        public double hard_dif_duration_multiplier = 0.8;
        public double normal_dif_duration_multiplier = 1.0;
        public double easy_dif_duration_multiplier = 1.3;

        private ConfigInner() {
        }
    }
}

