/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood;

import java.util.Calendar;
import java.util.Optional;
import java.util.Random;
import moonfather.cookyourfood.CookYourFoodMod;
import moonfather.cookyourfood.EffectPools;
import moonfather.cookyourfood.FoodResolver;
import moonfather.cookyourfood.storage.RecipeCache;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6860;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class EventHandlers {
    private static final Random random = new Random();

    public static void onItemUse(class_1937 world, class_1309 user, class_1799 itemStack) {
        class_1657 player;
        if (world.method_8608() || user instanceof class_1657 && (player = (class_1657)user).method_7325()) {
            return;
        }
        if (itemStack.method_58694(class_9334.field_50075) == null) {
            return;
        }
        FoodResolver.RawFoodRank rank = FoodResolver.Resolve(itemStack, world);
        if (rank.equals((Object)FoodResolver.RawFoodRank.NotACookableFood)) {
            return;
        }
        if (rank.equals((Object)FoodResolver.RawFoodRank.OkayToEat)) {
            return;
        }
        int effectId = EventHandlers.GetSessionEffectId(user, itemStack);
        if (rank.equals((Object)FoodResolver.RawFoodRank.Severe)) {
            EventHandlers.ApplySevereEffect(user, effectId);
        } else if (rank.equals((Object)FoodResolver.RawFoodRank.Light)) {
            EventHandlers.ApplyLightEffect(user, effectId);
        } else if (rank.equals((Object)FoodResolver.RawFoodRank.Normal)) {
            EventHandlers.ApplyNormalEffect(user, effectId);
        }
    }

    public static void onServerStarted(MinecraftServer minecraftServer) {
        EffectPools.getLight();
        RecipeCache.clearAndRecreate(minecraftServer);
    }

    public static void onDataPacksReloaded(MinecraftServer minecraftServer, class_6860 closeableResourceManager, boolean success) {
        if (!success) {
            return;
        }
        RecipeCache.clearAndRecreate(minecraftServer);
    }

    private static int GetSessionEffectId(class_1309 player, class_1799 item) {
        return EventHandlers.GetSessionEffectId(player, item.method_7909());
    }

    private static int GetSessionEffectId(class_1309 player, class_1792 item) {
        int pl = player.method_5628();
        int it = item != null ? class_1792.method_7880((class_1792)item) : 0;
        int ho = Calendar.getInstance().get(11);
        int mi = Calendar.getInstance().get(12);
        return Math.abs(1500450271 * pl + 15487457 * it + 15485917 * ho + 71 * (mi < 30 ? 1 : 0)) % 100 + 1;
    }

    private static void ApplyLoadedEffect(class_1309 player, int sessionEffectId, EffectPools.EffectLevel loaded) {
        int index;
        int r = sessionEffectId > 0 ? sessionEffectId : random.nextInt(100) + 1;
        for (index = 0; index < loaded.effects.length && r > loaded.effects[index].weight; r -= loaded.effects[index].weight, ++index) {
        }
        if (index < loaded.effects.length) {
            for (EffectPools.EffectInternal ei : loaded.effects[index].list) {
                Optional ref = class_7923.field_41174.method_10223(class_2960.method_60654((String)ei.effect_id));
                if (ref.isEmpty()) continue;
                EventHandlers.ApplyEffectInternal(player, (class_6880<class_1291>)((class_6880)ref.get()), ei.duration_in_sec, ei.effect_level);
            }
        }
    }

    private static void ApplyLightEffect(class_1309 player, int sessionEffectId) {
        EventHandlers.ApplyLoadedEffect(player, sessionEffectId, EffectPools.getLight());
    }

    private static void ApplyNormalEffect(class_1309 player, int sessionEffectId) {
        EventHandlers.ApplyLoadedEffect(player, sessionEffectId, EffectPools.getNormal());
    }

    private static void ApplySevereEffect(class_1309 player, int sessionEffectId) {
        EventHandlers.ApplyLoadedEffect(player, sessionEffectId, EffectPools.getSevere());
    }

    private static void ApplyEffectInternal(class_1309 player, class_6880<class_1291> effect, int durationInSeconds, int level) {
        int duration = (int)Math.round((double)(durationInSeconds * 20) * EventHandlers.GetDifficultyMultiplier(player));
        class_1293 existing = player.method_6112(effect);
        if (existing != null) {
            float timeMultiplier = player.method_73183().method_8409().method_43057();
            if (((class_1291)effect.comp_349()).equals(class_1294.field_5903)) {
                timeMultiplier *= 0.5f;
            }
            duration = Math.round(timeMultiplier * (float)duration + 1.0f);
            duration += existing.method_5584();
            level = Math.max(level, existing.method_5578());
        }
        player.method_6092(new class_1293(effect, duration, level));
    }

    private static double GetDifficultyMultiplier(class_1309 player) {
        if (player.method_73183().method_8407() == class_1267.field_5805 || player.method_73183().method_8407() == class_1267.field_5801) {
            return CookYourFoodMod.CONFIG.EasyDifDurationMultiplier;
        }
        if (player.method_73183().method_8407() == class_1267.field_5802) {
            return CookYourFoodMod.CONFIG.NormalDifDurationMultiplier;
        }
        return CookYourFoodMod.CONFIG.HardDifDurationMultiplier;
    }
}

