/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import moonfather.cookyourfood.Constants;
import moonfather.cookyourfood.storage.RecipeCache;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9334;

public class FoodResolver {
    private static final Map<class_1792, RawFoodRank> foodMap = new HashMap<class_1792, RawFoodRank>();

    public static RawFoodRank Resolve(class_1799 stack, class_1937 world) {
        RawFoodRank rank = foodMap.getOrDefault(stack.method_7909(), RawFoodRank.NotMapped);
        if (!rank.equals((Object)RawFoodRank.NotMapped)) {
            return rank;
        }
        if (stack.method_31573(Constants.Tags.OK_TO_EAT_RAW)) {
            foodMap.put(stack.method_7909(), RawFoodRank.OkayToEat);
            return RawFoodRank.OkayToEat;
        }
        if (stack.method_31573(Constants.Tags.RAW_FOOD_SEVERE)) {
            foodMap.put(stack.method_7909(), RawFoodRank.Severe);
            return RawFoodRank.Severe;
        }
        if (stack.method_31573(Constants.Tags.RAW_FOOD_LIGHT)) {
            foodMap.put(stack.method_7909(), RawFoodRank.Light);
            return RawFoodRank.Light;
        }
        if (stack.method_31573(Constants.Tags.RAW_FOOD_NORMAL)) {
            foodMap.put(stack.method_7909(), RawFoodRank.Normal);
            return RawFoodRank.Normal;
        }
        rank = RawFoodRank.NotACookableFood;
        Optional<class_1799> output = RecipeCache.getCookingOutput(stack, world);
        if (output.isPresent() && !output.get().method_7960() && output.get().method_58694(class_9334.field_50075) != null) {
            rank = RawFoodRank.Normal;
        }
        foodMap.put(stack.method_7909(), rank);
        return rank;
    }

    public static enum RawFoodRank {
        NotMapped,
        NotACookableFood,
        OkayToEat,
        Light,
        Normal,
        Severe;

    }
}

