/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionMod;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionSettings;
import me.ivan.ivancarpetaddition.commands.replaceproperties.ReplacePropertiesCommand;
import me.ivan.ivancarpetaddition.commands.xpcounter.XPCounter;
import me.ivan.ivancarpetaddition.commands.xpcounter.XPCounterCommand;
import me.ivan.ivancarpetaddition.logging.ICALoggerRegistry;
import me.ivan.ivancarpetaddition.network.ICASyncProtocol;
import me.ivan.ivancarpetaddition.network.carpetclient.CarpetClient;
import me.ivan.ivancarpetaddition.translations.ICATranslations;
import me.ivan.ivancarpetaddition.utils.doc.DocumentGeneration;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IvanCarpetAdditionServer
implements CarpetExtension {
    private static final IvanCarpetAdditionServer INSTANCE = new IvanCarpetAdditionServer();
    public static final String shortName = "ica";
    public static final String name = IvanCarpetAdditionMod.getModId();
    public static final String fancyName = "Ivan Carpet Addition";
    public static final String compactName = name.replace("-", "");
    public static final Logger LOGGER = LogManager.getLogger((String)"Ivan Carpet Addition");
    public static MinecraftServer minecraftServer;

    public String version() {
        return name;
    }

    public static IvanCarpetAdditionServer getInstance() {
        return INSTANCE;
    }

    public void registerExtension() {
        CarpetServer.manageExtension((CarpetExtension)this);
    }

    public void onGameStarted() {
        LOGGER.info("Ivan Carpet Addition " + IvanCarpetAdditionMod.getVersion() + " loaded");
        LOGGER.info("Thank you for using " + shortName.toUpperCase() + "!");
        LOGGER.info(shortName.toUpperCase() + " is open source, u can find it here: https://github.com/Ivan-1F/Ivan-Carpet-Addition");
        LOGGER.info(shortName.toUpperCase() + " is still in development, it may not work well");
        LOGGER.info("If u find any bug, please report them here: https://github.com/Ivan-1F/Ivan-Carpet-Addition/issues");
        CarpetServer.settingsManager.parseSettingsClass(IvanCarpetAdditionSettings.class);
        CarpetServer.settingsManager.addRuleObserver((serverCommandSource, currentRuleState, originalUserTest) -> {
            if (IvanCarpetAdditionSettings.icaSyncProtocol) {
                CarpetClient.onValueChanged(currentRuleState.name, currentRuleState.get().toString());
            }
        });
        ICATranslations.loadTranslations();
        ICASyncProtocol.init();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            DocumentGeneration.generateDocuments();
        }
    }

    public void onServerLoaded(MinecraftServer server) {
        minecraftServer = server;
        XPCounter.attachServer(server);
    }

    public void onServerClosed(MinecraftServer server) {
        XPCounter.detachServer();
    }

    public void onTick(MinecraftServer server) {
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        XPCounterCommand.getInstance().registerCommand(dispatcher);
        ReplacePropertiesCommand.getInstance().registerCommand(dispatcher);
    }

    public void onPlayerLoggedIn(class_3222 player) {
        if (IvanCarpetAdditionSettings.icaSyncProtocol) {
            ICASyncProtocol.onPlayerLoggedIn(player);
        }
        XPCounter.onPlayerLoggedIn(player);
    }

    public void onPlayerLoggedOut(class_3222 player) {
        if (IvanCarpetAdditionSettings.icaSyncProtocol) {
            ICASyncProtocol.onPlayerLoggedOut(player);
        }
        if (IvanCarpetAdditionSettings.xpCounter) {
            XPCounter.onPlayerLoggedOut(player);
        }
    }

    public void registerLoggers() {
        ICALoggerRegistry.registerLoggers();
    }

    public Map<String, String> canHasTranslations(String lang) {
        HashMap trimmedTranslation = Maps.newHashMap();
        String prefix = ICATranslations.TRANSLATION_KEY_PREFIX + "carpet_extension.";
        ICATranslations.getTranslation(lang).forEach((key, value) -> {
            if (key.startsWith(prefix)) {
                trimmedTranslation.put(key.substring(prefix.length()), value);
            }
        });
        return trimmedTranslation;
    }
}

