/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.commands.xpcounter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionSettings;
import me.ivan.ivancarpetaddition.commands.xpcounter.SpawnReason;
import me.ivan.ivancarpetaddition.commands.xpcounter.interfaces.IExperienceOrbEntity;
import me.ivan.ivancarpetaddition.mixins.command.xpcounter.ExperienceOrbEntityAccessor;
import me.ivan.ivancarpetaddition.translations.TranslationContext;
import me.ivan.ivancarpetaddition.translations.Translator;
import me.ivan.ivancarpetaddition.utils.Messenger;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class XPCounter
extends TranslationContext {
    public static final Map<class_3222, XPCounter> COUNTERS = Maps.newHashMap();
    private static MinecraftServer attachedServer;
    private static final Translator TRANSLATOR;
    private final class_3222 player;
    public final Map<SpawnReason, Integer> counter = Maps.newHashMap();
    private long startTick;
    private long startMillis;

    public static MinecraftServer getAttachedServer() {
        return attachedServer;
    }

    public static Translator getStaticTranslator() {
        return TRANSLATOR;
    }

    public static void attachServer(MinecraftServer server) {
        attachedServer = server;
    }

    public static void detachServer() {
        attachedServer = null;
    }

    public static void onPlayerLoggedIn(class_3222 serverPlayerEntity) {
        if (IvanCarpetAdditionSettings.xpCounter) {
            XPCounter.addPlayer(serverPlayerEntity);
        }
    }

    private static void addPlayer(class_3222 serverPlayerEntity) {
        COUNTERS.put(serverPlayerEntity, new XPCounter(serverPlayerEntity));
    }

    public static void onPlayerLoggedOut(class_3222 serverPlayerEntity) {
        COUNTERS.remove(serverPlayerEntity);
    }

    public XPCounter(class_3222 player) {
        super("command.xpcounter");
        this.player = player;
    }

    public static XPCounter getCounter(class_3222 player) {
        return COUNTERS.get(player);
    }

    public void add(class_1303 experienceOrb) {
        if (this.startTick == 0L) {
            this.startTick = XPCounter.getAttachedServer().method_3847(class_1937.field_25179).method_8510();
            this.startMillis = System.currentTimeMillis();
        }
        int amount = ((ExperienceOrbEntityAccessor)experienceOrb).getAmount();
        if (!(experienceOrb instanceof IExperienceOrbEntity)) {
            this.counter.putIfAbsent(SpawnReason.UNKNOWN, 0);
            this.counter.put(SpawnReason.UNKNOWN, this.counter.get(SpawnReason.UNKNOWN) + amount);
        } else {
            SpawnReason spawnReason = ((IExperienceOrbEntity)experienceOrb).getSpawnReason();
            if (spawnReason == null) {
                this.counter.putIfAbsent(SpawnReason.UNKNOWN, 0);
                this.counter.put(SpawnReason.UNKNOWN, this.counter.get(SpawnReason.UNKNOWN) + amount);
            } else {
                this.counter.putIfAbsent(spawnReason, 0);
                this.counter.put(spawnReason, this.counter.get(spawnReason) + amount);
            }
        }
    }

    public static Stream<String> getPlayers() {
        return COUNTERS.keySet().stream().map(class_1657::method_5477).map(class_2561::getString);
    }

    public void reset() {
        this.counter.clear();
        this.startTick = XPCounter.getAttachedServer().method_3847(class_1937.field_25179).method_8510();
        this.startMillis = System.currentTimeMillis();
    }

    public static void resetAll() {
        COUNTERS.values().forEach(XPCounter::reset);
    }

    public boolean isEmpty() {
        return this.counter.isEmpty() || this.getTotalExperience() == 0;
    }

    public static List<class_2554> formatAll(boolean realTime) {
        ArrayList<class_2554> text = new ArrayList<class_2554>();
        COUNTERS.forEach((player, counter) -> {
            List<class_2554> temp;
            if (!counter.isEmpty() && (temp = counter.format(realTime, false)).size() > 1) {
                if (!text.isEmpty()) {
                    text.add(Messenger.s(""));
                }
                text.addAll(temp);
            }
        });
        if (text.isEmpty()) {
            text.add(XPCounter.getStaticTranslator().tr("no_counter", new Object[0]));
        }
        return text;
    }

    public List<class_2554> format(boolean realTime, boolean brief) {
        if (this.counter.isEmpty()) {
            if (brief) {
                return Collections.singletonList(Messenger.formatting(this.tr("no_xp.brief", this.player.method_5477()), "g"));
            }
            return Collections.singletonList(this.tr("no_xp", this.player.method_5477()));
        }
        int total = this.getTotalExperience();
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : XPCounter.getAttachedServer().method_3847(class_1937.field_25179).method_8510() - this.startTick, 1L);
        if (total == 0) {
            if (brief) {
                return Collections.singletonList(Messenger.formatting(this.tr("no_xp.timed.brief", this.player, (double)ticks / 1200.0), "c"));
            }
            String translationKey = "no_xp.timed" + (realTime ? ".realtime" : "");
            return Collections.singletonList(Messenger.c(this.tr(translationKey, this.player.method_5477(), (double)ticks / 1200.0)));
        }
        ArrayList<class_2554> items = new ArrayList<class_2554>();
        String time = String.format("%.2f", (double)ticks * 1.0 / 1200.0);
        String rate = String.format("%.1f", (double)total * 1.0 * 72000.0 / (double)ticks);
        if (brief) {
            return Collections.singletonList(Messenger.formatting(this.tr("summary.brief", this.player.method_5477().getString(), total, rate, time), "c"));
        }
        String translationKey = "summary" + (realTime ? ".realtime" : "");
        items.add(Messenger.c(this.tr(translationKey, this.player.method_5477().getString(), time, total, rate), Messenger.fancy("nb", Messenger.s("[X]"), this.tr("click_to_reset", this.player.method_5477().getString()), new class_2558(class_2558.class_2559.field_11750, "/xpcounter " + this.player.method_5477().getString() + " reset"))));
        this.counter.keySet().forEach(key -> {
            int count = this.counter.get(key);
            items.add(Messenger.c(Messenger.s("- "), key.toText(), Messenger.s(String.format(": %d, %.1f/h", count, (double)count * 72000.0 / (double)ticks))));
        });
        return items;
    }

    public int getTotalExperience() {
        return this.counter.values().stream().mapToInt(Integer::intValue).sum();
    }

    public static void sendRestarted(class_2168 source, class_3222 player) {
        if (player == null) {
            Messenger.tell(source, XPCounter.getStaticTranslator().tr("restarted_all", new Object[0]));
        } else {
            Messenger.tell(source, XPCounter.getStaticTranslator().tr("restarted", player.method_5477().getString()));
        }
    }

    public static void onEnable() {
        COUNTERS.clear();
        XPCounter.getAttachedServer().method_3760().method_14571().forEach(XPCounter::addPlayer);
    }

    public static void onDisable() {
        COUNTERS.clear();
    }

    static {
        TRANSLATOR = new XPCounter(null).getTranslator();
    }
}

