/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.commands.xpcounter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionSettings;
import me.ivan.ivancarpetaddition.commands.AbstractCommand;
import me.ivan.ivancarpetaddition.commands.xpcounter.XPCounter;
import me.ivan.ivancarpetaddition.utils.CarpetModUtil;
import me.ivan.ivancarpetaddition.utils.Messenger;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2554;
import net.minecraft.class_3222;

public class XPCounterCommand
extends AbstractCommand {
    private static final String NAME = "xpcounter";
    private static final XPCounterCommand INSTANCE = new XPCounterCommand();

    private XPCounterCommand() {
        super(NAME);
    }

    public static XPCounterCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(player -> CarpetModUtil.canUseCommand(player, IvanCarpetAdditionSettings.xpCounter));
        root.executes(context -> XPCounterCommand.listAllCounters((class_2168)context.getSource(), false));
        root.then(class_2170.method_9247((String)"reset").executes(ctx -> this.resetCounter((class_2168)ctx.getSource(), (class_3222)null)));
        root.then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9264(XPCounter.getPlayers(), (SuggestionsBuilder)b)).executes(ctx -> this.displayCounter((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), false)));
        root.then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9264(XPCounter.getPlayers(), (SuggestionsBuilder)b)).then(class_2170.method_9247((String)"reset").executes(ctx -> this.resetCounter((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player")))));
        root.then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9264(XPCounter.getPlayers(), (SuggestionsBuilder)b)).then(class_2170.method_9247((String)"realtime").executes(ctx -> this.displayCounter((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), true))));
        dispatcher.register(root);
    }

    private static int listAllCounters(class_2168 source, boolean realtime) {
        for (class_2554 message : XPCounter.formatAll(realtime)) {
            Messenger.tell(source, message);
        }
        return 1;
    }

    private class_3222 getPlayerFromName(String name) {
        return XPCounter.getAttachedServer().method_3760().method_14566(name);
    }

    private int resetCounter(class_2168 source, String player) {
        return this.resetCounter(source, this.getPlayerFromName(player));
    }

    private int resetCounter(class_2168 source, class_3222 player) {
        if (player == null) {
            XPCounter.resetAll();
        } else {
            XPCounter counter = XPCounter.getCounter(player);
            counter.reset();
        }
        XPCounter.sendRestarted(source, player);
        return 1;
    }

    private int displayCounter(class_2168 source, String player, boolean realtime) {
        return this.displayCounter(source, this.getPlayerFromName(player), realtime);
    }

    private int displayCounter(class_2168 source, class_3222 player, boolean realtime) {
        XPCounter counter = XPCounter.getCounter(player);
        for (class_2554 message : counter.format(realtime, false)) {
            Messenger.tell(source, message);
        }
        return 1;
    }
}

