/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.logging;

import carpet.logging.HUDLogger;
import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import java.lang.reflect.Field;
import me.ivan.ivancarpetaddition.logging.loggers.AbstractLogger;
import me.ivan.ivancarpetaddition.logging.loggers.shulker.ShulkerLogger;
import me.ivan.ivancarpetaddition.logging.loggers.xpcounter.XPCounterHUDLogger;

public class ICALoggerRegistry {
    public static boolean __xpcounter;
    public static boolean __shulker;

    public static void registerLoggers() {
        ICALoggerRegistry.register(XPCounterHUDLogger.getInstance());
        ICALoggerRegistry.register(ShulkerLogger.getInstance());
    }

    private static void register(AbstractLogger logger) {
        ICALoggerRegistry.register(logger.createCarpetLogger());
    }

    private static void register(Logger logger) {
        LoggerRegistry.registerLogger((String)logger.getLogName(), (Logger)logger);
    }

    public static Field getLoggerField(String logName) {
        try {
            return ICALoggerRegistry.class.getField("__" + logName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Failed to get logger field \"%s\" @ %s", logName, "Ivan Carpet Addition"));
        }
    }

    public static Logger standardLogger(String logName, String def, String[] options) {
        return new Logger(ICALoggerRegistry.getLoggerField(logName), logName, def, options);
    }

    public static HUDLogger standardHUDLogger(String logName, String def, String[] options) {
        return new HUDLogger(ICALoggerRegistry.getLoggerField(logName), logName, def, options);
    }
}

