/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.network.carpetclient;

import carpet.CarpetServer;
import carpet.settings.ParsedRule;
import carpet.utils.Translations;
import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.List;
import me.ivan.ivancarpetaddition.mixins.network.CustomPayloadC2SPacketAccessor;
import me.ivan.ivancarpetaddition.network.IICAClient;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CarpetClient
implements IICAClient {
    public static String MOD_ID = "carpetclient";
    public static class_2960 CARPET_RULES = CarpetClient.id("carpet_rules");
    public static class_2960 VALUE_CHANGED = CarpetClient.id("value_changed");
    public static class_2960 HI = CarpetClient.id("hi");
    public static class_2960 HELLO = CarpetClient.id("hello");
    public static final List<class_3222> playerWithCarpetClient = Lists.newArrayList();

    private static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static void onRequestingRules(class_3222 player) {
        playerWithCarpetClient.add(player);
        CarpetClient.sendRulesToPlayer(player);
    }

    public static void sendRulesToPlayer(class_3222 player) {
        class_2499 rules = new class_2499();
        for (ParsedRule rule : CarpetServer.settingsManager.getRules()) {
            class_2487 packedRule = new class_2487();
            packedRule.method_10582("name", rule.name);
            packedRule.method_10582("type", rule.type.getSimpleName());
            packedRule.method_10582("value", rule.getAsString());
            packedRule.method_10582("defaultValue", rule.defaultValue.toString());
            packedRule.method_10582("description", rule.translatedDescription());
            packedRule.method_10582("translatedName", rule.translatedName().replaceAll(" \\(.*\\)", ""));
            packedRule.method_10582("translatedDescription", rule.translatedDescription());
            class_2499 categories = new class_2499();
            rule.categories.forEach(category -> categories.add((Object)class_2519.method_23256((String)Translations.tr((String)("category." + category)))));
            packedRule.method_10566("categories", (class_2520)categories);
            rules.add((Object)packedRule);
        }
        class_2487 data = new class_2487();
        data.method_10566("rules", (class_2520)rules);
        player.field_13987.method_14364((class_2596)new class_2658(CARPET_RULES, new class_2540(Unpooled.buffer()).method_10794(data)));
    }

    public static void onValueChanged(String rule, String newValue) {
        class_2487 data = new class_2487();
        data.method_10582("rule", rule);
        data.method_10582("newValue", newValue);
        playerWithCarpetClient.forEach(player -> player.field_13987.method_14364((class_2596)new class_2658(VALUE_CHANGED, new class_2540(Unpooled.buffer()).method_10794(data))));
    }

    @Override
    public String getNamespace() {
        return MOD_ID;
    }

    @Override
    public boolean onCustomPayload(class_3222 sender, class_2817 packet) {
        class_2960 channel = ((CustomPayloadC2SPacketAccessor)packet).getChannel();
        if (HELLO.equals((Object)channel)) {
            CarpetClient.onRequestingRules(sender);
            return true;
        }
        return false;
    }

    @Override
    public void onPlayerLoggedIn(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2658(HI, new class_2540(Unpooled.buffer())));
    }

    @Override
    public void onPlayerLoggedOut(class_3222 player) {
        playerWithCarpetClient.remove(player);
    }
}

