/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.translations;

import carpet.CarpetSettings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionServer;
import me.ivan.ivancarpetaddition.mixins.translations.StyleAccessor;
import me.ivan.ivancarpetaddition.mixins.translations.TranslatableTextAccessor;
import me.ivan.ivancarpetaddition.translations.ServerPlayerEntityWithClientLanguage;
import me.ivan.ivancarpetaddition.utils.FileUtil;
import me.ivan.ivancarpetaddition.utils.Messenger;
import net.minecraft.class_2554;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class ICATranslations {
    public static final String DEFAULT_LANGUAGE = "en_us";
    public static final String TRANSLATION_NAMESPACE = IvanCarpetAdditionServer.compactName;
    public static final String TRANSLATION_KEY_PREFIX = TRANSLATION_NAMESPACE + ".";
    private static final String LANG_DIR = String.format("assets/%s/lang", TRANSLATION_NAMESPACE);
    public static final Map<String, Map<String, String>> translations = Maps.newLinkedHashMap();
    public static final Set<String> languages = Sets.newHashSet();

    private static List<String> getAvailableTranslations() {
        try {
            String dataStr = FileUtil.readFile(LANG_DIR + "/meta/languages.yml");
            Map yamlMap = (Map)new Yaml().load(dataStr);
            return (List)yamlMap.get("languages");
        }
        catch (Exception e) {
            IvanCarpetAdditionServer.LOGGER.warn("Failed to load translations");
            return Lists.newArrayList();
        }
    }

    public static void loadTranslations() {
        ICATranslations.getAvailableTranslations().forEach(ICATranslations::loadTranslation);
    }

    public static void loadTranslation(String language) {
        String data;
        String path = String.format("%s/%s.yml", LANG_DIR, language);
        try {
            data = FileUtil.readFile(path);
        }
        catch (IOException e) {
            IvanCarpetAdditionServer.LOGGER.warn("Failed to load translation: " + language);
            return;
        }
        Map yaml = (Map)new Yaml().load(data);
        LinkedHashMap translation = Maps.newLinkedHashMap();
        ICATranslations.build(translation, yaml, "");
        translations.put(language, translation);
        languages.add(language);
    }

    public static void build(Map<String, String> translation, Map<String, Object> yaml, String prefix) {
        yaml.forEach((key, value) -> {
            String fullKey;
            String string = prefix.isEmpty() ? key : (fullKey = !key.equals(".") ? prefix + "." + key : prefix);
            if (value instanceof String) {
                translation.put(fullKey, (String)value);
            } else if (value instanceof Map) {
                ICATranslations.build(translation, (Map)value, fullKey);
            } else {
                throw new RuntimeException(String.format("Unknown type %s in with key %s", value.getClass(), fullKey));
            }
        });
    }

    public static String getServerLanguage() {
        return CarpetSettings.language.equalsIgnoreCase("none") ? DEFAULT_LANGUAGE : CarpetSettings.language;
    }

    @NotNull
    public static Map<String, String> getTranslation(String lang) {
        return translations.getOrDefault(lang, Collections.emptyMap());
    }

    @Nullable
    public static String translateKeyToFormattedString(String lang, String key) {
        return ICATranslations.getTranslation(lang.toLowerCase()).get(key);
    }

    public static class_2554 translate(class_2554 text, class_3222 player) {
        return ICATranslations.translate(text, ((ServerPlayerEntityWithClientLanguage)player).getClientLanguage$ICA().toLowerCase());
    }

    public static class_2554 translate(class_2554 text) {
        return ICATranslations.translate(text, ICATranslations.getServerLanguage());
    }

    public static class_2554 translate(class_2554 text, String lang) {
        return ICATranslations.translate(text, lang, false);
    }

    public static class_2554 translate(class_2554 text, String lang, boolean suppressWarnings) {
        class_2568 hoverEvent;
        class_2588 translatableText;
        if (text instanceof class_2588 && (translatableText = (class_2588)text).method_11022().startsWith(TRANSLATION_KEY_PREFIX)) {
            String formattedString = ICATranslations.translateKeyToFormattedString(lang, translatableText.method_11022());
            if (formattedString == null) {
                formattedString = ICATranslations.translateKeyToFormattedString(DEFAULT_LANGUAGE, translatableText.method_11022());
            }
            if (formattedString != null) {
                class_2554 origin = text;
                TranslatableTextAccessor fixedTranslatableText = (TranslatableTextAccessor)new class_2588(formattedString, translatableText.method_11023());
                try {
                    fixedTranslatableText.getTranslations().clear();
                    fixedTranslatableText.invokeSetTranslation(formattedString);
                    text = Messenger.c(fixedTranslatableText.getTranslations().stream().map(stringVisitable -> {
                        if (stringVisitable instanceof class_2554) {
                            return (class_2554)stringVisitable;
                        }
                        return Messenger.s(stringVisitable.getString());
                    }).toArray());
                }
                catch (class_2590 e) {
                    text = Messenger.s(formattedString);
                }
                text.method_10855().addAll(origin.method_10855());
                text.method_10862(origin.method_10866());
            } else if (!suppressWarnings) {
                IvanCarpetAdditionServer.LOGGER.warn("Unknown translation key {}", (Object)translatableText.method_11022());
            }
        }
        if ((hoverEvent = ((StyleAccessor)text.method_10866()).getHoverEventField()) != null) {
            Object hoverText = hoverEvent.method_10891(hoverEvent.method_10892());
            if (hoverEvent.method_10892() == class_2568.class_5247.field_24342 && hoverText instanceof class_2554) {
                text.method_10862(text.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)ICATranslations.translate((class_2554)hoverText, lang))));
            }
        }
        List siblings = text.method_10855();
        siblings.replaceAll(text1 -> ICATranslations.translate((class_2554)text1, lang));
        return text;
    }
}

