/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static String readFile(String path) throws IOException {
        InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Null input stream from path " + path);
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    public static void writeToFile(Path path, String text) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(text);
        }
    }

    public static String getFileExtension(String path) {
        return FilenameUtils.getExtension((String)path);
    }

    public static String removeFileExtension(String path) {
        return FilenameUtils.removeExtension((String)path);
    }
}

