/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils;

import com.google.common.collect.ImmutableMap;
import me.ivan.ivancarpetaddition.mixins.translations.StyleAccessor;
import me.ivan.ivancarpetaddition.translations.ICATranslations;
import me.ivan.ivancarpetaddition.translations.Translator;
import me.ivan.ivancarpetaddition.utils.TextUtil;
import me.ivan.ivancarpetaddition.utils.compat.DimensionWrapper;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class Messenger {
    private static final Translator translator = new Translator("util");
    private static final ImmutableMap<DimensionWrapper, class_2554> DIMENSION_NAME = ImmutableMap.of((Object)DimensionWrapper.OVERWORLD, (Object)Messenger.tr("createWorld.customize.preset.overworld", new Object[0]), (Object)DimensionWrapper.THE_NETHER, (Object)Messenger.tr("advancements.nether.root.title", new Object[0]), (Object)DimensionWrapper.THE_END, (Object)Messenger.tr("advancements.end.root.title", new Object[0]));

    public static class_2554 c(Object ... fields) {
        return carpet.utils.Messenger.c((Object[])fields);
    }

    public static class_2554 s(Object text) {
        return new class_2585(text.toString());
    }

    public static class_2554 s(Object text, String carpetStyle) {
        return Messenger.formatting(Messenger.s(text), carpetStyle);
    }

    public static class_2554 s(Object text, class_124 textFormatting) {
        return Messenger.formatting(Messenger.s(text), textFormatting);
    }

    public static class_2554 fancy(String carpetStyle, class_2554 displayText, class_2554 hoverText, class_2558 clickEvent) {
        class_2554 text = Messenger.copy(displayText);
        if (carpetStyle != null) {
            text.method_10862(Messenger.parseCarpetStyle(carpetStyle));
        }
        if (hoverText != null) {
            Messenger.hover(text, hoverText);
        }
        if (clickEvent != null) {
            Messenger.click(text, clickEvent);
        }
        return text;
    }

    public static class_2554 fancy(class_2554 displayText, class_2554 hoverText, class_2558 clickEvent) {
        return Messenger.fancy(null, displayText, hoverText, clickEvent);
    }

    public static class_2554 tr(String key, Object ... args) {
        return new class_2588(key, args);
    }

    public static class_2554 copy(class_2554 text) {
        return (class_2554)text.method_27661();
    }

    public static void tell(class_2168 source, class_2554 text) {
        class_1297 entity = source.method_9228();
        text = entity instanceof class_3222 ? ICATranslations.translate(text, (class_3222)entity) : ICATranslations.translate(text);
        source.method_9226((class_2561)text, false);
    }

    public static class_2554 formatting(class_2554 text, class_124 ... formattings) {
        text.method_27695(formattings);
        return text;
    }

    public static class_2554 formatting(class_2554 text, String carpetStyle) {
        class_2583 textStyle = text.method_10866();
        StyleAccessor parsedStyle = (StyleAccessor)Messenger.parseCarpetStyle(carpetStyle);
        textStyle = textStyle.method_27703(parsedStyle.getColorField());
        textStyle = textStyle.method_10982(parsedStyle.getBoldField());
        textStyle = textStyle.method_10978(parsedStyle.getItalicField());
        ((StyleAccessor)textStyle).setUnderlinedField(parsedStyle.getUnderlineField());
        ((StyleAccessor)textStyle).setStrikethroughField(parsedStyle.getStrikethroughField());
        ((StyleAccessor)textStyle).setObfuscatedField(parsedStyle.getObfuscatedField());
        return Messenger.style(text, textStyle);
    }

    public static class_2554 style(class_2554 text, class_2583 style) {
        text.method_10862(style);
        return text;
    }

    public static class_2554 click(class_2554 text, class_2558 clickEvent) {
        Messenger.style(text, text.method_10866().method_10958(clickEvent));
        return text;
    }

    public static class_2554 hover(class_2554 text, class_2568 hoverEvent) {
        Messenger.style(text, text.method_10866().method_10949(hoverEvent));
        return text;
    }

    public static class_2554 hover(class_2554 text, class_2554 hoverText) {
        return Messenger.hover(text, new class_2568(class_2568.class_5247.field_24342, (Object)hoverText));
    }

    public static class_2554 entity(String style, class_1297 entity) {
        class_2554 entityBaseName = (class_2554)entity.method_5864().method_5897();
        class_2554 entityDisplayName = (class_2554)entity.method_5477();
        class_2554 hoverText = Messenger.c(translator.tr("entity_type", entityBaseName, Messenger.s(class_1299.method_5890((class_1299)entity.method_5864()).toString())), Messenger.newLine(), Messenger.getTeleportHint(entityDisplayName));
        return Messenger.fancy(style, entityDisplayName, hoverText, new class_2558(class_2558.class_2559.field_11745, TextUtil.tp(entity)));
    }

    private static class_2554 getTeleportHint(class_2554 dest) {
        return translator.tr("teleport_hint", dest);
    }

    public static class_2554 newLine() {
        return Messenger.s("\n");
    }

    public static class_2554 dimension(DimensionWrapper dim) {
        class_2554 dimText = (class_2554)DIMENSION_NAME.get((Object)dim);
        return dimText != null ? Messenger.copy(dimText) : Messenger.s(dim.getIdentifierString());
    }

    private static class_2554 __coord(String style, @Nullable DimensionWrapper dim, String posStr, String command) {
        class_2554 hoverText = Messenger.s("");
        hoverText.method_10852((class_2561)Messenger.getTeleportHint(Messenger.s(posStr)));
        if (dim != null) {
            hoverText.method_27693("\n");
            hoverText.method_10852((class_2561)translator.tr("teleport_hint.dimension", new Object[0]));
            hoverText.method_27693(": ");
            hoverText.method_10852((class_2561)Messenger.dimension(dim));
        }
        return Messenger.fancy(style, Messenger.s(posStr), hoverText, new class_2558(class_2558.class_2559.field_11745, command));
    }

    public static class_2554 coord(String style, class_243 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtil.coord(pos), TextUtil.tp(pos, dim));
    }

    public static class_2554 coord(String style, class_2382 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtil.coord(pos), TextUtil.tp(pos, dim));
    }

    public static class_2554 coord(String style, class_1923 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtil.coord(pos), TextUtil.tp(pos, dim));
    }

    public static class_2554 coord(String style, class_243 pos) {
        return Messenger.__coord(style, null, TextUtil.coord(pos), TextUtil.tp(pos));
    }

    public static class_2554 coord(String style, class_2382 pos) {
        return Messenger.__coord(style, null, TextUtil.coord(pos), TextUtil.tp(pos));
    }

    public static class_2554 coord(String style, class_1923 pos) {
        return Messenger.__coord(style, null, TextUtil.coord(pos), TextUtil.tp(pos));
    }

    public static class_2554 coord(class_243 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_2554 coord(class_2382 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_2554 coord(class_1923 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_2554 coord(class_243 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_2554 coord(class_2382 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_2554 coord(class_1923 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_2583 parseCarpetStyle(String style) {
        return carpet.utils.Messenger.parseStyle((String)style);
    }
}

