/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils.doc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionServer;
import me.ivan.ivancarpetaddition.translations.ICATranslations;
import me.ivan.ivancarpetaddition.translations.Translator;
import me.ivan.ivancarpetaddition.utils.FileUtil;

public abstract class AbstractDocumentGenerator {
    private static final Translator translator = new Translator("doc");
    protected final StringBuffer buffer = new StringBuffer();
    protected final Consumer<String> writeln = line -> this.buffer.append((String)line).append("\n");
    protected String language = "en_us";

    public AbstractDocumentGenerator() {
        this.prepare();
    }

    public static String inlineCode(String text) {
        return "`" + text + "`";
    }

    public static List<String> inlineCode(List<String> text) {
        return text.stream().map(AbstractDocumentGenerator::inlineCode).collect(Collectors.toList());
    }

    public String tr(String key, Object ... args) {
        return ICATranslations.translate(translator.tr(key, args), this.getLanguage()).getString();
    }

    public void setLanguage(String language) {
        this.language = language;
        this.buffer.setLength(0);
        this.prepare();
    }

    public void prepare() {
        this.writeHeader();
        this.writeLanguageSwitcher();
    }

    public void writeLanguageSwitcher() {
        if (this.getLanguage().equals("en_us")) {
            this.writeln.accept(String.format("**English** | [\u4e2d\u6587](%s)", this.getFileName("zh_cn")));
        } else {
            this.writeln.accept(String.format("[English](%s) | **\u4e2d\u6587**", this.getFileName("en_us")));
        }
        this.writeln.accept("");
    }

    public String getLanguage() {
        return this.language;
    }

    public abstract void generate();

    public String getFileName() {
        return this.getFileName(this.getLanguage());
    }

    public abstract String getHeader();

    private void writeHeader() {
        this.writeln.accept("# " + this.getHeader());
        this.writeln.accept("");
    }

    public abstract String getFileName(String var1);

    public void toFile(Path path) {
        try {
            FileUtil.writeToFile(path, this.buffer.toString());
        }
        catch (IOException e) {
            IvanCarpetAdditionServer.LOGGER.error((Object)e);
        }
    }
}

