/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils.doc;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import me.ivan.ivancarpetaddition.utils.doc.AbstractDocumentGenerator;
import me.ivan.ivancarpetaddition.utils.doc.DocumentGeneration;

public class CommandDocumentGenerator
extends AbstractDocumentGenerator {
    private final List<String> commands = ImmutableList.of((Object)"xpcounter", (Object)"replaceproperties");

    @Override
    public void generate() {
        DocumentGeneration.getIndexGenerator().startNewSection(String.format("[%s](%s)", this.tr("command.header", new Object[0]), this.getFileName()));
        for (String command : this.commands) {
            DocumentGeneration.getIndexGenerator().accept(String.format("[%s](%s)", command, this.getFileName() + "#" + command));
        }
        DocumentGeneration.getIndexGenerator().writeln.accept("");
    }

    @Override
    public void toFile(Path path) {
    }

    @Override
    public String getHeader() {
        return this.tr("command.header", new Object[0]);
    }

    @Override
    public String getFileName(String lang) {
        if (lang.equals("en_us")) {
            return "commands.md";
        }
        return String.format("commands-%s.md", lang);
    }
}

