/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils.doc;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionServer;
import me.ivan.ivancarpetaddition.translations.ICATranslations;
import me.ivan.ivancarpetaddition.utils.doc.AbstractDocumentGenerator;
import me.ivan.ivancarpetaddition.utils.doc.CommandDocumentGenerator;
import me.ivan.ivancarpetaddition.utils.doc.IndexGenerator;
import me.ivan.ivancarpetaddition.utils.doc.LoggerDocumentGenerator;
import me.ivan.ivancarpetaddition.utils.doc.RuleDocumentGenerator;

public class DocumentGeneration {
    private static final Path DOC_DIRECTORY = Paths.get("docs", new String[0]);
    private static final List<AbstractDocumentGenerator> GENERATORS = ImmutableList.of((Object)new RuleDocumentGenerator(), (Object)new CommandDocumentGenerator(), (Object)new LoggerDocumentGenerator());
    private static final IndexGenerator indexGenerator = new IndexGenerator();

    public static IndexGenerator getIndexGenerator() {
        return indexGenerator;
    }

    public static void generateDocuments() {
        for (String language : ICATranslations.languages) {
            IvanCarpetAdditionServer.LOGGER.info("Generating ICA documents of language " + language);
            indexGenerator.setLanguage(language);
            for (AbstractDocumentGenerator generator : GENERATORS) {
                generator.setLanguage(language);
                generator.generate();
                generator.toFile(DOC_DIRECTORY.resolve(generator.getFileName()));
                IvanCarpetAdditionServer.LOGGER.info("Generated: " + DOC_DIRECTORY.resolve(generator.getFileName()));
            }
            indexGenerator.toFile(DOC_DIRECTORY.resolve(indexGenerator.getFileName()));
            IvanCarpetAdditionServer.LOGGER.info("The index of language " + language + " has been generated at " + DOC_DIRECTORY.resolve(indexGenerator.getFileName()));
        }
    }
}

