/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils.doc;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import me.ivan.ivancarpetaddition.utils.doc.AbstractDocumentGenerator;
import me.ivan.ivancarpetaddition.utils.doc.DocumentGeneration;

public class LoggerDocumentGenerator
extends AbstractDocumentGenerator {
    private final List<String> loggers = ImmutableList.of((Object)"xpcounter", (Object)"shulker");

    @Override
    public void generate() {
        DocumentGeneration.getIndexGenerator().startNewSection(String.format("[%s](%s)", this.tr("logger.header", new Object[0]), this.getFileName()));
        for (String logger : this.loggers) {
            DocumentGeneration.getIndexGenerator().accept(String.format("[%s](%s)", logger, this.getFileName() + "#" + logger));
        }
        DocumentGeneration.getIndexGenerator().writeln.accept("");
    }

    @Override
    public void toFile(Path path) {
    }

    @Override
    public String getHeader() {
        return this.tr("logger.header", new Object[0]);
    }

    @Override
    public String getFileName(String lang) {
        if (lang.equals("en_us")) {
            return "loggers.md";
        }
        return String.format("loggers-%s.md", lang);
    }
}

