/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.ivancarpetaddition.utils.doc;

import carpet.settings.Rule;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import me.ivan.ivancarpetaddition.IvanCarpetAdditionSettings;
import me.ivan.ivancarpetaddition.utils.doc.AbstractDocumentGenerator;
import me.ivan.ivancarpetaddition.utils.doc.DocumentGeneration;
import me.ivan.ivancarpetaddition.utils.doc.RuleFormatter;

public class RuleDocumentGenerator
extends AbstractDocumentGenerator {
    @Override
    public void generate() {
        DocumentGeneration.getIndexGenerator().startNewSection(String.format("[%s](%s)", this.tr("rule.header", new Object[0]), this.getFileName()));
        Field[] fields = IvanCarpetAdditionSettings.class.getDeclaredFields();
        for (Field field : fields = (Field[])Arrays.stream(fields).sorted(Comparator.comparing(Field::getName)).toArray(Field[]::new)) {
            Rule annotation = field.getAnnotation(Rule.class);
            if (annotation == null) continue;
            RuleFormatter rule = new RuleFormatter(annotation, field, this.getLanguage());
            this.writeln.accept("### " + rule.getName());
            this.writeln.accept("");
            this.writeln.accept(rule.getDescription());
            this.writeln.accept("");
            rule.getExtras().ifPresent(extras -> this.writeln.accept(Joiner.on((String)"\n\n").join((Iterable)extras) + "\n"));
            this.writeln.accept(String.format(" - %s: %s", this.tr("rule.type", new Object[0]), RuleDocumentGenerator.inlineCode(rule.getType())));
            this.writeln.accept(String.format(" - %s: %s", this.tr("rule.default_value", new Object[0]), RuleDocumentGenerator.inlineCode(rule.getDefaultValue())));
            this.writeln.accept(String.format(" - %s: %s", this.tr("rule.suggested_options", new Object[0]), Joiner.on((String)", ").join(RuleDocumentGenerator.inlineCode(rule.getSuggestedOptions()))));
            this.writeln.accept(String.format(" - %s: %s", this.tr("rule.categories", new Object[0]), Joiner.on((String)", ").join(RuleDocumentGenerator.inlineCode(rule.getCategories()))));
            this.writeln.accept("");
            DocumentGeneration.getIndexGenerator().accept(String.format("[%s](%s)", rule.getNameSimple(), rule.getLink(this.getLanguage())));
        }
        DocumentGeneration.getIndexGenerator().writeln.accept("");
    }

    @Override
    public String getHeader() {
        return this.tr("rule.header", new Object[0]);
    }

    @Override
    public String getFileName(String lang) {
        if (lang.equals("en_us")) {
            return "rules.md";
        }
        return String.format("rules-%s.md", lang);
    }
}

