#ifndef INCLUDE_SKY
    #define INCLUDE_SKY

    #include "/lib/colors/lightAndAmbientColors.glsl"
    #include "/lib/colors/skyColors.glsl"

    #ifdef CAVE_FOG
        #include "/lib/atmospherics/fog/caveFactor.glsl"
    #endif

    vec3 GetSky(float VdotU, float VdotS, float dither, bool doGlare, bool doGround) {
        // Smoothness and brightness variables
        float VdotUmax0 = max(VdotU, 0.0);
        float horizonFactor = pow(1.0 - VdotUmax0, 1.6);
        float timeShift = sin(frameTimeCounter * 0.02) * 0.02; // subtle color breathing

        // ✨ Medieval natural sky gradient colors ✨
        vec3 topColor    = vec3(0.10, 0.25, 0.55); // deep blue upper sky
        vec3 midColor    = vec3(0.25, 0.55, 0.75); // cyan-blue mid layer
        vec3 bottomColor = vec3(0.70, 0.85, 1.00); // bright near horizon

        // Natural gradient blending
        vec3 skyColor = mix(topColor, midColor, horizonFactor * 0.6);
        vec3 finalSky = mix(skyColor, bottomColor, pow(horizonFactor, 2.2));

        // Add slight natural tone variation (gives life & depth)
        finalSky += vec3(0.02, 0.03, 0.04) * timeShift;

        // Gentle daylight boost for realism
        finalSky *= 1.05;

        // Optional: soft sun glare for a natural feel
        if (doGlare && VdotS > 0.97) {
            float glare = pow(VdotS, 90.0);
            finalSky += glare * vec3(1.0, 0.9, 0.7); // warm sun tint
        }

        // Subtle atmospheric dithering
        finalSky += (dither - 0.5) / 256.0;

        // Blend cave fog softly if present
        #ifdef CAVE_FOG
            finalSky = mix(finalSky, vec3(0.15, 0.2, 0.25), GetCaveFactor() * 0.5);
        #endif

        return clamp(finalSky, 0.0, 1.0);
    }

    vec3 GetLowQualitySky(float VdotU, float VdotS, float dither, bool doGlare, bool doGround) {
        float horizonFactor = pow(1.0 - max(VdotU, 0.0), 1.5);
        vec3 baseColor = mix(vec3(0.15, 0.35, 0.6), vec3(0.65, 0.85, 1.0), horizonFactor);
        if (doGlare && VdotS > 0.9) {
            baseColor += vec3(0.9, 0.85, 0.7) * pow(VdotS, 50.0);
        }
        return baseColor + (dither - 0.5) / 256.0;
    }

#endif // INCLUDE_SKY
