#ifndef INCLUDE_SKY_COLORS
#define INCLUDE_SKY_COLORS

#ifdef OVERWORLD
    vec3 skyColorSqrt = sqrt(skyColor);
    float invRainStrength2 = (1.0 - rainStrength) * (1.0 - rainStrength);
    vec3 skyColorM = mix(max(skyColorSqrt, vec3(0.1, 0.3, 0.45)), skyColorSqrt, invRainStrength2);
    vec3 skyColorM2 = mix(max(skyColor, sunFactor * vec3(0.1, 0.3, 0.45)), skyColor, invRainStrength2);

    #ifdef SPECIAL_BIOME_WEATHER
        vec3 nmscSnowM = inSnowy * vec3(-0.3, 0.05, 0.2);
        vec3 nmscDryM = inDry * vec3(-0.3);
        vec3 ndscSnowM = inSnowy * vec3(-0.25, -0.01, 0.25);
        vec3 ndscDryM = inDry * vec3(-0.05, -0.09, -0.1);
    #else
        vec3 nmscSnowM = vec3(0.0), nmscDryM = vec3(0.0), ndscSnowM = vec3(0.0), ndscDryM = vec3(0.0);
    #endif
    #if RAIN_STYLE == 2
        vec3 nmscRainMP = vec3(-0.15, 0.025, 0.1);
        vec3 ndscRainMP = vec3(-0.125, -0.005, 0.125);
        #ifdef SPECIAL_BIOME_WEATHER
            vec3 nmscRainM = inRainy * ndscRainMP;
            vec3 ndscRainM = inRainy * ndscRainMP;
        #else
            vec3 nmscRainM = ndscRainMP;
            vec3 ndscRainM = ndscRainMP;
        #endif
    #else
        vec3 nmscRainM = vec3(0.0), ndscRainM = vec3(0.0);
    #endif

    vec3 nmscWeatherM = vec3(-0.1, -0.4, -0.6) + vec3(0.0, 0.06, 0.12) * noonFactor;
    vec3 ndscWeatherM = vec3(-0.15, -0.3, -0.42) + vec3(0.0, 0.02, 0.08) * noonFactor;

    // ☀️ Natural clear-sky day colors (blue → cyan gradient)
    vec3 noonUpSkyColor     = pow(skyColorM * vec3(0.55, 0.75, 1.0), vec3(4.0)); // deep blue top
    vec3 noonMiddleSkyColor = mix(noonUpSkyColor, vec3(0.45, 0.85, 1.1), 0.4);   // bluish-cyan mid
    vec3 noonDownSkyColor   = mix(noonUpSkyColor, vec3(0.65, 0.95, 1.0), 0.8);   // near-horizon cyan

    vec3 sunsetUpSkyColor     = skyColorM2 * (vec3(1.7, 0.58, 0.58) + vec3(0.1, 0.2, 0.35) * rainFactor2);
    vec3 sunsetMiddleSkyColor = skyColorM2 * (vec3(1.8, 1.3, 1.2) + vec3(0.15, 0.25, -0.05) * rainFactor2);
    vec3 sunsetDownSkyColorP  = vec3(1.45, 0.86, 0.5) - vec3(0.8, 0.3, 0.0) * rainFactor;
    vec3 sunsetDownSkyColor   = sunsetDownSkyColorP * 0.5 + 0.25 * sunsetMiddleSkyColor;

    // 🌤 Smooth blend between noon and sunset
    vec3 dayUpSkyColor     = mix(noonUpSkyColor, sunsetUpSkyColor, invNoonFactor2);
    vec3 dayMiddleSkyColor = mix(noonMiddleSkyColor, sunsetMiddleSkyColor, invNoonFactor2);
    vec3 dayDownSkyColor   = mix(noonDownSkyColor, sunsetDownSkyColor, invNoonFactor2);

    // 🌙 Night sky (unchanged)
    vec3 nightColFactor      = vec3(0.3961, 0.0706, 0.8196) * (1.0 - 0.5 * rainFactor) + skyColor;
    vec3 nightUpSkyColor     = pow(nightColFactor, vec3(0.90)) * 0.4;
    vec3 nightMiddleSkyColor = sqrt(nightUpSkyColor) * 0.68;
    vec3 nightDownSkyColor   = nightMiddleSkyColor * vec3(0.82, 0.82, 0.88);
#endif

#endif //INCLUDE_SKY_COLORS
