/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.gui.widget;

import com.bejker.interactionmanager.config.Config;
import com.bejker.interactionmanager.gui.options.denylist.ItemInteractionsScreen;
import com.bejker.interactionmanager.gui.widget.SearchableListWidget;
import com.bejker.interactionmanager.search.SearchUtil;
import com.bejker.interactionmanager.util.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ItemListWidget
extends SearchableListWidget<ItemInteractionsScreen> {
    private static class_1792 selectedItem = null;
    private HashSet<class_1792> searchEntryItems = new HashSet();

    public ItemListWidget(ItemInteractionsScreen parent, class_310 client) {
        super(parent, client, parent.field_22789 / 2 - 5, parent.field_49503.method_57727(), parent.field_49503.method_48998(), 23);
    }

    @Nullable
    public class_1792 getSelectedItemOrNull() {
        return selectedItem;
    }

    @Override
    public void updateEntries() {
        super.updateEntries();
        HashSet<class_1792> blockEntryItems = new HashSet<class_1792>();
        HashSet<class_1792> deniedEntryItems = new HashSet<class_1792>();
        if (this.lastSearch != null && !this.lastSearch.isBlank()) {
            SearchUtil.searchItems(this.lastSearch, -1, item -> Util.doesOverrideMethod(item.getClass(), "use", class_1792.class) || Util.doesOverrideMethod(item.getClass(), "useOnBlock", class_1792.class) || class_1747.class.isAssignableFrom(item.getClass())).stream().distinct().map(x$0 -> new SearchItemEntry(this, (class_1792)x$0)).forEach(this::addSearchEntry);
        } else {
            this.method_25321((class_350.class_351)new AllEntry(this));
            for (Map.Entry<class_1792, HashSet<class_2248>> mapEntry : Config.DENIED_ITEM_INTERACTIONS.entrySet()) {
                class_1792 item2 = mapEntry.getKey();
                HashSet<class_2248> blocks = mapEntry.getValue();
                if (item2 != selectedItem && (blocks == null || blocks.isEmpty()) || item2 == class_1802.field_8162) continue;
                this.method_25321((class_350.class_351)new ItemEntry(item2));
                blockEntryItems.add(item2);
            }
            for (class_1792 item3 : Config.DENIED_ITEMS) {
                if (item3 != selectedItem && item3 == null || item3 == class_1802.field_8162 || blockEntryItems.contains(item3)) continue;
                this.method_25321((class_350.class_351)new ItemEntry(item3));
                deniedEntryItems.add(item3);
            }
        }
        if (!blockEntryItems.contains(selectedItem) && !deniedEntryItems.contains(selectedItem) && this.searchEntryItems.isEmpty() && selectedItem != null && selectedItem != class_1802.field_8162) {
            this.method_25321((class_350.class_351)new ItemEntry(selectedItem));
        }
    }

    private void addSearchEntry(SearchItemEntry searchItemEntry) {
        if (this.searchEntryItems == null) {
            this.searchEntryItems = new HashSet();
        }
        this.searchEntryItems.add(searchItemEntry.item);
        this.method_25321((class_350.class_351)searchItemEntry);
    }

    protected void method_25339() {
        super.method_25339();
        if (this.searchEntryItems == null) {
            this.searchEntryItems = new HashSet();
        }
        this.searchEntryItems.clear();
    }

    public class AllEntry
    extends SearchItemEntry {
        public AllEntry(ItemListWidget this$0) {
            super(this$0, class_1802.field_8162);
            this.item_name_text = class_2561.method_43471((String)"text.interactionmanager.deny_using_all_items.title");
            this.item_id_text = class_2561.method_43471((String)"text.interactionmanager.deny_using_all_items.tooltip");
            this.bgColor = -888205553;
        }
    }

    public class ItemEntry
    extends SearchableListWidget.Entry {
        public class_2561 item_name_text;
        public class_2561 item_id_text;
        final class_1792 item;
        private static final int MAX_CHARS = 30;

        public ItemEntry(class_1792 item) {
            super(ItemListWidget.this);
            class_6880 entry = class_7923.field_41178.method_47983((Object)item);
            this.item_name_text = class_2561.method_30163((String)item.method_63680().method_10858(30));
            String id = entry.method_55840();
            this.item_id_text = class_2561.method_43470((String)id.substring(0, Math.min(id.length(), 30)));
            this.item = item;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            selectedItem = selectedItem == this.item ? null : this.item;
            ItemListWidget.this.updateEntries();
            ((ItemInteractionsScreen)ItemListWidget.this.parent).updateBlacklistedBlocks();
            return true;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_x = x + entryWidth / 32;
            if (Config.RENDER_ITEMS_IN_BLOCK_DENY_LIST.getValue()) {
                ref_x += 14;
            }
            int ref_y = y + entryHeight - 9;
            boolean isSelected = selectedItem == this.item;
            context.method_27535(((ItemListWidget)ItemListWidget.this).field_22740.field_1772, this.item_name_text, ref_x, ref_y, isSelected ? -359926 : -1);
            context.method_27535(((ItemListWidget)ItemListWidget.this).field_22740.field_1772, this.item_id_text, ref_x, ref_y + 10, -8355712);
            if (Config.RENDER_ITEMS_IN_BLOCK_DENY_LIST.getValue()) {
                context.method_51445(new class_1799((class_1935)this.item), ref_x - 20, ref_y);
            }
            if (isSelected) {
                context.method_25294(x - 1, ref_y - 2, x + entryWidth - 3, ref_y + entryHeight * 2 - 6, 537590282);
                context.method_49601(x - 2, ref_y - 3, entryWidth, entryHeight * 2 - 2, -55924054);
            }
        }
    }

    public class SearchItemEntry
    extends ItemEntry {
        private static final int lines = 2;
        protected int bgColor = 0x10AAAAAA;

        public SearchItemEntry(ItemListWidget this$0, class_1792 item) {
            super(item);
        }

        public void method_49568(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean isSelected;
            int ref_y = y + entryHeight - 9 - 1;
            boolean bl = isSelected = selectedItem == this.item;
            if (!isSelected) {
                context.method_49601(x - 2, ref_y - 2, entryWidth, entryHeight * 2 - 2, 0xFBABABA);
            }
            context.method_25294(x - 1, ref_y - 1, x + entryWidth - 3, ref_y + entryHeight * 2 - 4, this.bgColor);
        }
    }
}

