/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.util;

import java.lang.reflect.Method;

public class Util {
    public static String translationKeyOf(String type, String id) {
        return type + ".interactionmanager." + id;
    }

    public static String getTooltipTranslationKey(String type, String key) {
        return Util.translationKeyOf(type, key) + ".tooltip";
    }

    public static boolean doesOverrideMethod(Class<?> clazz, String methodName) {
        return Util.doesOverrideMethod(clazz, methodName, clazz.getSuperclass());
    }

    public static boolean doesOverrideMethod(Class<?> clazz, String methodName, Class<?> superClass) {
        if (superClass == Object.class || clazz == superClass) {
            return false;
        }
        try {
            Method method = Util.getMethod(clazz, methodName);
            Method method1 = Util.getMethod(superClass, methodName);
            return !method.getDeclaringClass().equals(method1.getDeclaringClass());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method[] methods;
        if (clazz == null) {
            throw new NoSuchMethodException(methodName);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        try {
            return Util.getMethod(clazz.getSuperclass(), methodName);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("No method named " + methodName + " in " + String.valueOf(clazz) + " (or super classes)");
        }
    }
}

