/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager;

import com.bejker.interactionmanager.config.Config;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public class RenderProtected {
    private static final HashMap<UUID, Long> recentlyProtectedEntities = new HashMap();
    private static final HashMap<UUID, Long> recentlyUnprotectedEntities = new HashMap();
    public static final long RENDER_PROTECTED_TIME = 20L;
    public static final float RENDER_PROTECTED_CUTOFF = 20.0f;

    public static void markAsProtected(class_1297 entity) {
        recentlyProtectedEntities.put(entity.method_5667(), entity.method_37908().method_8510() + 20L);
    }

    public static void markAsUnprotected(class_1297 entity) {
        recentlyUnprotectedEntities.put(entity.method_5667(), entity.method_37908().method_8510() + 20L);
    }

    public static <T extends class_1297> void onRender(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (!Config.RENDER_PROTECTED_ENTITIES.getValue()) {
            return;
        }
        Long protectedUntil = recentlyProtectedEntities.get(entity.method_5667());
        if (protectedUntil != null) {
            long delta = protectedUntil - entity.method_37908().method_8510();
            if (delta <= 0L) {
                recentlyProtectedEntities.remove(entity.method_5667());
                return;
            }
            RenderProtected.calcAndDrawBox(entity, matrices, vertexConsumers, 0.3f, 0.85f, 0.3f, delta);
        } else {
            Long unprotectedUntil = recentlyUnprotectedEntities.get(entity.method_5667());
            if (unprotectedUntil == null) {
                return;
            }
            long delta = unprotectedUntil - entity.method_37908().method_8510();
            if (delta <= 0L) {
                recentlyUnprotectedEntities.remove(entity.method_5667());
                return;
            }
            RenderProtected.calcAndDrawBox(entity, matrices, vertexConsumers, 0.85f, 0.3f, 0.3f, delta);
        }
    }

    private static <T extends class_1297> void calcAndDrawBox(T entity, class_4587 matrices, class_4597 vertexConsumers, float r, float g, float b, long delta) {
        float new_delta = Math.min((float)delta / 20.0f, 1.0f);
        float alpha = class_3532.method_16439((float)RenderProtected.easeInQuad(new_delta), (float)0.0f, (float)0.71f);
        RenderProtected.drawBox(entity, matrices, vertexConsumers, r, g, b, alpha);
    }

    private static <T extends class_1297> void drawBox(T entity, class_4587 matrices, class_4597 vertexConsumers, float r, float g, float b, float a) {
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_49047());
        class_238 box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
        class_761.method_3258((class_4587)matrices, (class_4588)consumer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)r, (float)g, (float)b, (float)a);
    }

    private static float easeInQuad(float x) {
        return (float)Math.pow(x, 2.0);
    }
}

