/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.search;

import com.bejker.interactionmanager.search.GeneralizedSuffixTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SearchUtil {
    private static SearchTree<class_2248> blockSearchTree;
    private static SearchTree<class_1299<?>> entitySearchTree;
    private static String current_language;

    public static void init() {
        class_6880 entry;
        String language = class_310.method_1551().method_1526().method_4669();
        if (language.equals(current_language) && SearchUtil.blockSearchTree.list.size() == class_7923.field_41175.method_10204()) {
            return;
        }
        current_language = language;
        blockSearchTree = new SearchTree();
        entitySearchTree = new SearchTree();
        for (class_2248 block : class_7923.field_41175) {
            entry = class_7923.field_41175.method_47983((Object)block);
            blockSearchTree.put(SearchUtil.getLocalizedBlockName(block), block);
            blockSearchTree.put(entry.method_55840(), block);
        }
        for (class_1299 entity_type : class_7923.field_41177) {
            entry = class_7923.field_41177.method_47983((Object)entity_type);
            entitySearchTree.put(SearchUtil.getLocalizedEntityName(entity_type), entity_type);
            entitySearchTree.put(entry.method_55840(), entity_type);
        }
    }

    public static Collection<class_2248> searchBlocks(String word) {
        return SearchUtil.searchBlocks(word, -1);
    }

    public static Collection<class_2248> searchBlocks(String word, int results) {
        SearchUtil.init();
        return blockSearchTree.search(word, results);
    }

    public static Collection<class_1299<?>> searchEntities(String word) {
        return SearchUtil.searchEntities(word, -1);
    }

    public static Collection<class_1299<?>> searchEntities(String word, int results) {
        SearchUtil.init();
        return entitySearchTree.search(word, results);
    }

    public static String getLocalizedBlockName(class_2248 block) {
        return ((String)block.method_9518().method_10851().method_27659(Optional::of).get()).toLowerCase(Locale.ROOT);
    }

    public static String getLocalizedEntityName(class_1299<?> entityType) {
        return ((String)entityType.method_5897().method_10851().method_27659(Optional::of).get()).toLowerCase(Locale.ROOT);
    }

    private static class SearchTree<T> {
        GeneralizedSuffixTree tree = new GeneralizedSuffixTree();
        ArrayList<T> list = new ArrayList();
        HashMap<Integer, Integer> remap = new HashMap();
        private int idx = 0;

        public void put(String word, T entry) {
            this.tree.put(word, this.idx++);
            int remap_idx = this.list.indexOf(entry);
            this.remap.put(this.idx, this.list.size());
            if (remap_idx == -1) {
                this.list.add(entry);
            }
        }

        private T mapIndexToEntry(int i) {
            return this.list.get(Objects.requireNonNullElse(this.remap.get(i), i));
        }

        public Collection<T> search(String word, int results) {
            return this.tree.search(word, results).stream().map(this::mapIndexToEntry).toList();
        }
    }
}

