/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.gui.widget;

import com.bejker.interactionmanager.config.Config;
import com.bejker.interactionmanager.gui.options.denylist.BlockDenylistScreen;
import com.bejker.interactionmanager.gui.widget.SearchableListWidget;
import com.bejker.interactionmanager.search.SearchUtil;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8666;

public class BlockListWidget
extends SearchableListWidget<BlockDenylistScreen> {
    public BlockListWidget(BlockDenylistScreen parent, class_310 client) {
        super(parent, client);
    }

    @Override
    protected void updateEntries() {
        super.updateEntries();
        if (this.lastSearch != null && !this.lastSearch.isBlank()) {
            SearchUtil.searchBlocks(this.lastSearch, -1, x -> !Config.DENIED_BLOCKS.contains(x)).stream().map(x$0 -> new SearchBlockEntry((class_2248)x$0)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }
        this.method_25321((class_350.class_351)new CategoryEntry((class_2561)class_2561.method_43471((String)"category.interactionmanager.denied_blocks")));
        for (class_2248 i : Config.DENIED_BLOCKS) {
            this.method_25321((class_350.class_351)new BlockEntry(i));
        }
    }

    public class CategoryEntry
    extends SearchableListWidget.Entry {
        private final class_2561 text;

        public CategoryEntry(class_2561 text) {
            super(BlockListWidget.this);
            this.text = text;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int text_width = ((BlockListWidget)BlockListWidget.this).field_22740.field_1772.method_27525((class_5348)this.text);
            context.method_27535(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, this.text, x + entryWidth / 2 - text_width / 2, y + entryHeight / 4 + 2, -1);
        }
    }

    public class BlockEntry
    extends SearchableListWidget.Entry {
        public final class_2561 block_name_text;
        public final class_2561 block_id_text;
        private final class_4185 button;
        private final class_2248 block;
        private static final int MAX_CHARS = 30;
        static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"pending_invite/accept"), class_2960.method_60656((String)"pending_invite/accept_highlighted"));

        public BlockEntry(class_2248 block) {
            super(BlockListWidget.this);
            class_6880 entry = class_7923.field_41175.method_47983((Object)block);
            this.block_name_text = class_2561.method_30163((String)block.method_9518().method_10858(30));
            String id = entry.method_55840();
            this.block_id_text = class_2561.method_43470((String)id.substring(0, Math.min(id.length(), 30))).method_54663(-8355712);
            this.button = this.createButton(block);
            this.block = block;
        }

        class_4185 createButton(class_2248 block) {
            return new class_344(20, 20, BUTTON_TEXTURES, button -> {
                Config.DENIED_BLOCKS.remove(block);
                BlockListWidget.this.updateEntries();
            }, (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_x = x + entryWidth / 32;
            if (Config.RENDER_ITEMS_IN_BLOCK_DENY_LIST.getValue()) {
                ref_x += 14;
            }
            int ref_y = y + entryHeight - 9;
            context.method_27535(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, this.block_name_text, ref_x, ref_y, -1);
            context.method_27535(((BlockListWidget)BlockListWidget.this).field_22740.field_1772, this.block_id_text, ref_x, ref_y + 10, -8355712);
            this.button.method_46421(x + entryWidth - this.button.method_25368() - 3);
            this.button.method_46419(ref_y - 1);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
            if (Config.RENDER_ITEMS_IN_BLOCK_DENY_LIST.getValue()) {
                context.method_51445(new class_1799((class_1935)this.block), ref_x - 20, ref_y);
            }
        }
    }

    public class SearchBlockEntry
    extends BlockEntry {
        private static final int lines = 2;
        static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"pending_invite/reject"), class_2960.method_60656((String)"pending_invite/reject_highlighted"));

        public SearchBlockEntry(class_2248 block) {
            super(block);
        }

        @Override
        class_4185 createButton(class_2248 block) {
            return new class_344(20, 20, BUTTON_TEXTURES, button -> {
                Config.DENIED_BLOCKS.add(block);
                BlockListWidget.this.updateEntries();
            }, (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }

        public void method_49568(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_y = y + entryHeight - 9 - 1;
            context.method_49601(x - 2, ref_y - 2, entryWidth, entryHeight * 2 - 2, 0xFBABABA);
            context.method_25294(x - 1, ref_y - 1, x + entryWidth - 3, ref_y + entryHeight * 2 - 4, 0x10AAAAAA);
        }
    }
}

