/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.gui.widget;

import com.bejker.interactionmanager.config.Config;
import com.bejker.interactionmanager.gui.options.blacklist.EntityBlacklistScreen;
import com.bejker.interactionmanager.search.SearchUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8666;

public class EntityListWidget
extends class_4265<Entry> {
    private final EntityBlacklistScreen parent;
    private String last_search = "";

    public EntityListWidget(EntityBlacklistScreen parent, class_310 client) {
        super(client, parent.field_22789, parent.field_49503.method_57727(), parent.field_49503.method_48998(), 23);
        this.parent = parent;
        this.updateEntries();
    }

    private void updateEntries() {
        this.method_25339();
        if (this.last_search != null && !this.last_search.isBlank()) {
            SearchUtil.searchEntities(this.last_search).stream().distinct().filter(x -> !Config.BLACKLISTED_ENTITIES.contains(x)).map(x$0 -> new SearchEntityEntry((class_1299<?>)x$0)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }
        this.method_25321((class_350.class_351)new CategoryEntry((class_2561)class_2561.method_43471((String)"category.interactionmanager.blacklisted_entities")));
        for (class_1299<?> i : Config.BLACKLISTED_ENTITIES) {
            this.method_25321((class_350.class_351)new EntityEntry(i));
        }
        if (this.method_25340() == 0) {
            return;
        }
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
        String search = this.parent.getSearch();
        if (!search.equals(this.last_search)) {
            this.last_search = search;
            this.updateEntries();
        }
        int rowLeft = this.method_25342();
        int rowWidth = this.method_25322();
        int itemHeight = this.field_22741 - 9 - 1;
        int entryCount = this.method_25340();
        for (int i = 0; i < entryCount; ++i) {
            int rowTop = this.method_25337(i);
            int rowBottom = this.method_25319(i);
            if (rowBottom < this.method_46427() || rowTop > this.method_55443()) continue;
            this.method_44397(context, mouseX, mouseY, delta, i, rowLeft, rowTop, rowWidth, itemHeight);
        }
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25405(mouseX, mouseY)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public class CategoryEntry
    extends Entry {
        private final class_2561 text;

        public CategoryEntry(class_2561 text) {
            this.text = text;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int text_width = ((EntityListWidget)EntityListWidget.this).field_22740.field_1772.method_27525((class_5348)this.text);
            context.method_27535(((EntityListWidget)EntityListWidget.this).field_22740.field_1772, this.text, x + entryWidth / 2 - text_width / 2, y + entryHeight / 4 + 2, -1);
        }
    }

    public class EntityEntry
    extends Entry {
        public final class_2561 block_name_text;
        public final class_2561 block_id_text;
        private final class_4185 button;
        static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"pending_invite/accept"), class_2960.method_60656((String)"pending_invite/accept_highlighted"));

        public EntityEntry(class_1299<?> type) {
            class_6880 entry = class_7923.field_41177.method_47983(type);
            this.block_name_text = type.method_5897();
            this.block_id_text = class_2561.method_30163((String)entry.method_55840()).method_27661().method_54663(-8355712);
            this.button = this.createButton(type);
        }

        class_4185 createButton(class_1299<?> type) {
            return new class_344(20, 20, BUTTON_TEXTURES, button -> {
                Config.BLACKLISTED_ENTITIES.remove(type);
                EntityListWidget.this.updateEntries();
            }, (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_x = x + entryWidth / 32;
            int ref_y = y + entryHeight - 9;
            context.method_27535(((EntityListWidget)EntityListWidget.this).field_22740.field_1772, this.block_name_text, ref_x, ref_y, -1);
            context.method_27535(((EntityListWidget)EntityListWidget.this).field_22740.field_1772, this.block_id_text, ref_x, ref_y + 10, -8355712);
            this.button.method_46421(x + entryWidth - this.button.method_25368() - 3);
            this.button.method_46419(ref_y - 1);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }

    public class SearchEntityEntry
    extends EntityEntry {
        private static final int lines = 2;
        static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"pending_invite/reject"), class_2960.method_60656((String)"pending_invite/reject_highlighted"));

        public SearchEntityEntry(class_1299<?> type) {
            super(type);
        }

        @Override
        class_4185 createButton(class_1299<?> type) {
            return new class_344(20, 20, BUTTON_TEXTURES, button -> {
                Config.BLACKLISTED_ENTITIES.add(type);
                EntityListWidget.this.updateEntries();
            }, (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }

        public void method_49568(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_y = y + entryHeight - 9 - 1;
            context.method_49601(x - 2, ref_y - 2, entryWidth, entryHeight * 2 - 2, 0xFBABABA);
            context.method_25294(x - 1, ref_y - 1, x + entryWidth - 3, ref_y + entryHeight * 2 - 4, 0x10AAAAAA);
        }
    }

    public abstract class Entry
    extends class_4265.class_4266<Entry> {
        public boolean method_25405(double mouseX, double mouseY) {
            return Objects.equals(EntityListWidget.this.method_25308(mouseX, mouseY), (Object)this);
        }
    }
}

