/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.search;

import com.bejker.interactionmanager.search.Edge;
import com.bejker.interactionmanager.search.Node;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;

public class GeneralizedSuffixTree {
    private int last = 0;
    private Node root;
    private Node activeLeaf = this.root = new Node();

    public Collection<Integer> search(String word) {
        return this.search(word, -1);
    }

    public Collection<Integer> search(String word, int results) {
        Node tmpNode = this.searchNode(word);
        if (tmpNode == null) {
            return Collections.EMPTY_LIST;
        }
        return tmpNode.getData(results);
    }

    public ResultInfo searchWithCount(String word, int to) {
        Node tmpNode = this.searchNode(word);
        if (tmpNode == null) {
            return new ResultInfo(Collections.EMPTY_LIST, 0);
        }
        return new ResultInfo(tmpNode.getData(to), tmpNode.getResultCount());
    }

    private Node searchNode(String word) {
        Node currentNode = this.root;
        for (int i = 0; i < word.length(); ++i) {
            int lenToMatch;
            char ch = word.charAt(i);
            Edge currentEdge = currentNode.getEdge(ch);
            if (null == currentEdge) {
                return null;
            }
            String label = currentEdge.getLabel();
            if (!word.regionMatches(i, label, 0, lenToMatch = Math.min(word.length() - i, label.length()))) {
                return null;
            }
            if (label.length() >= word.length() - i) {
                return currentEdge.getDest();
            }
            currentNode = currentEdge.getDest();
            i += lenToMatch - 1;
        }
        return null;
    }

    public void put(String key, int index) throws IllegalStateException {
        if (index < this.last) {
            throw new IllegalStateException("The input index must not be less than any of the previously inserted ones. Got " + index + ", expected at least " + this.last);
        }
        this.last = index;
        this.activeLeaf = this.root;
        String remainder = key;
        Node s = this.root;
        Object text = "";
        for (int i = 0; i < remainder.length(); ++i) {
            text = (String)text + remainder.charAt(i);
            text = ((String)text).intern();
            Pair<Node, String> active = this.update(s, (String)text, remainder.substring(i), index);
            active = this.canonize(active.getFirst(), active.getSecond());
            s = active.getFirst();
            text = active.getSecond();
        }
        if (null == this.activeLeaf.getSuffix() && this.activeLeaf != this.root && this.activeLeaf != s) {
            this.activeLeaf.setSuffix(s);
        }
    }

    private Pair<Boolean, Node> testAndSplit(Node inputs, String stringPart, char t, String remainder, int value) {
        Pair<Node, String> ret = this.canonize(inputs, stringPart);
        Node s = ret.getFirst();
        String str = ret.getSecond();
        if (!str.isEmpty()) {
            Edge g = s.getEdge(str.charAt(0));
            String label = g.getLabel();
            if (label.length() > str.length() && label.charAt(str.length()) == t) {
                return new Pair<Boolean, Node>(this, true, s);
            }
            String newlabel = label.substring(str.length());
            assert (label.startsWith(str));
            Node r = new Node();
            Edge newedge = new Edge(str, r);
            g.setLabel(newlabel);
            r.addEdge(newlabel.charAt(0), g);
            s.addEdge(str.charAt(0), newedge);
            return new Pair<Boolean, Node>(this, false, r);
        }
        Edge e = s.getEdge(t);
        if (null == e) {
            return new Pair<Boolean, Node>(this, false, s);
        }
        if (remainder.equals(e.getLabel())) {
            e.getDest().addRef(value);
            return new Pair<Boolean, Node>(this, true, s);
        }
        if (remainder.startsWith(e.getLabel())) {
            return new Pair<Boolean, Node>(this, true, s);
        }
        if (e.getLabel().startsWith(remainder)) {
            Node newNode = new Node();
            newNode.addRef(value);
            Edge newEdge = new Edge(remainder, newNode);
            e.setLabel(e.getLabel().substring(remainder.length()));
            newNode.addEdge(e.getLabel().charAt(0), e);
            s.addEdge(t, newEdge);
            return new Pair<Boolean, Node>(this, false, s);
        }
        return new Pair<Boolean, Node>(this, true, s);
    }

    private Pair<Node, String> canonize(Node s, String inputstr) {
        if ((inputstr = new String(inputstr.getBytes(), StandardCharsets.UTF_8)).isEmpty()) {
            return new Pair<Node, String>(this, s, inputstr);
        }
        Node currentNode = s;
        String str = inputstr;
        Edge g = s.getEdge(str.charAt(0));
        while (g != null && str.startsWith(g.getLabel())) {
            str = str.substring(g.getLabel().length());
            currentNode = g.getDest();
            if (str.length() <= 0) continue;
            g = currentNode.getEdge(str.charAt(0));
        }
        return new Pair<Node, String>(this, currentNode, str);
    }

    private Pair<Node, String> update(Node inputNode, String stringPart, String rest, int value) {
        Node s = inputNode;
        String tempstr = stringPart;
        char newChar = stringPart.charAt(stringPart.length() - 1);
        Node oldroot = this.root;
        Pair<Boolean, Node> ret = this.testAndSplit(s, tempstr.substring(0, tempstr.length() - 1), newChar, rest, value);
        Node r = ret.getSecond();
        boolean endpoint = ret.getFirst();
        while (!endpoint) {
            Node leaf;
            Edge tempEdge = r.getEdge(newChar);
            if (null != tempEdge) {
                leaf = tempEdge.getDest();
            } else {
                leaf = new Node();
                leaf.addRef(value);
                Edge newedge = new Edge(rest, leaf);
                r.addEdge(newChar, newedge);
            }
            if (this.activeLeaf != this.root) {
                this.activeLeaf.setSuffix(leaf);
            }
            this.activeLeaf = leaf;
            if (oldroot != this.root) {
                oldroot.setSuffix(r);
            }
            oldroot = r;
            if (null == s.getSuffix()) {
                assert (this.root == s);
                tempstr = tempstr.substring(1);
            } else {
                Pair<Node, String> canret = this.canonize(s.getSuffix(), this.safeCutLastChar(tempstr));
                s = canret.getFirst();
                tempstr = (canret.getSecond() + tempstr.charAt(tempstr.length() - 1)).intern();
            }
            ret = this.testAndSplit(s, this.safeCutLastChar(tempstr), newChar, rest, value);
            r = ret.getSecond();
            endpoint = ret.getFirst();
        }
        if (oldroot != this.root) {
            oldroot.setSuffix(r);
        }
        oldroot = this.root;
        return new Pair<Node, String>(this, s, tempstr);
    }

    Node getRoot() {
        return this.root;
    }

    private String safeCutLastChar(String seq) {
        if (seq.length() == 0) {
            return "";
        }
        return seq.substring(0, seq.length() - 1);
    }

    public int computeCount() {
        return this.root.computeAndCacheCount();
    }

    public static class ResultInfo {
        public int totalResults;
        public Collection<Integer> results;

        public ResultInfo(Collection<Integer> results, int totalResults) {
            this.totalResults = totalResults;
            this.results = results;
        }
    }

    private class Pair<A, B> {
        private final A first;
        private final B second;

        public Pair(GeneralizedSuffixTree generalizedSuffixTree, A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }
    }
}

