/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.config;

import com.bejker.interactionmanager.InteractionManager;
import com.bejker.interactionmanager.config.Config;
import com.bejker.interactionmanager.config.option.BooleanOption;
import com.bejker.interactionmanager.config.option.EnumOption;
import com.bejker.interactionmanager.config.option.IFileOnlyOption;
import com.bejker.interactionmanager.config.option.IOptionConvertable;
import com.bejker.interactionmanager.config.option.IRuntimeInternalOnlyOption;
import com.bejker.interactionmanager.config.option.OptionStorage;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ConfigManager {
    private static Path config_path;

    public static void loadConfig() {
        ConfigManager.setupConfigFile();
        if (!Files.exists(config_path, new LinkOption[0])) {
            ConfigManager.saveConfig();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(config_path);
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            boolean found_invalid = false;
            for (Field field : Config.class.getDeclaredFields()) {
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class)) continue;
                String field_name = field.getName().toLowerCase(Locale.ROOT);
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    BooleanOption option = (BooleanOption)field.get(null);
                    JsonPrimitive value = json.getAsJsonPrimitive(field_name);
                    if (value == null) continue;
                    option.setValue(value.getAsBoolean());
                    continue;
                }
                if (EnumOption.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                    Type generic;
                    JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT));
                    if (jsonPrimitive == null || !jsonPrimitive.isString() || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    EnumOption option = (EnumOption)field.get(null);
                    Enum found = null;
                    ArrayList<CallSite> valid_values = new ArrayList<CallSite>();
                    for (Enum value : (Enum[])((Class)generic).getEnumConstants()) {
                        String value_name = value.name().toLowerCase(Locale.ROOT);
                        valid_values.add((CallSite)((Object)("\"" + value_name + "\"")));
                        if (!value_name.equals(jsonPrimitive.getAsString())) continue;
                        found = value;
                        break;
                    }
                    if (found != null) {
                        OptionStorage.setEnumRaw(option.getKey(), found);
                        continue;
                    }
                    InteractionManager.CLIENT_LOGGER.error("Invalid option in Interaction Manager config; Path: \"{}\": \"{}\":\"{}\"; Restoring saved: \"{}\"; Valid values: {}", new Object[]{config_path, option.getKey(), jsonPrimitive.getAsString(), ((Enum)option.getValue()).name().toLowerCase(Locale.ROOT), valid_values});
                    found_invalid = true;
                    continue;
                }
                if (!Set.class.isAssignableFrom(field.getType()) || !field.getName().equals("BLACKLISTED_BLOCKS")) continue;
                JsonArray jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT));
                for (JsonElement element : jsonArray) {
                    class_2248 block = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)element.getAsString()));
                    Config.BLACKLISTED_BLOCKS.add(block);
                }
            }
            if (found_invalid) {
                ConfigManager.saveConfig();
            }
        }
        catch (IOException | IllegalAccessException e) {
            System.err.println("Couldn't load Interaction Manager config, using defaults.");
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        ConfigManager.setupConfigFile();
        JsonObject config = new JsonObject();
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class)) continue;
                String field_name = field.getName().toLowerCase(Locale.ROOT);
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    BooleanOption option = (BooleanOption)field.get(null);
                    config.addProperty(field_name, Boolean.valueOf(option.getValue()));
                    continue;
                }
                if (EnumOption.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                    Type generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    if (!(generic instanceof Class)) continue;
                    EnumOption option = (EnumOption)field.get(null);
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), OptionStorage.getEnumRaw(option.getKey(), (Class)generic).name().toLowerCase(Locale.ROOT));
                    continue;
                }
                if (!Set.class.isAssignableFrom(field.getType()) || !field.getName().equals("BLACKLISTED_BLOCKS")) continue;
                JsonArray array = new JsonArray();
                for (class_2248 block : Config.BLACKLISTED_BLOCKS) {
                    array.add(class_7923.field_41175.method_10221((Object)block).toString());
                }
                config.add(field_name, (JsonElement)array);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String string = InteractionManager.GSON.toJson((JsonElement)config);
        try {
            BufferedWriter writer = Files.newBufferedWriter(config_path, new OpenOption[0]);
            writer.write(string);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Couldn't load Interaction Manager config, using defaults.");
            e.printStackTrace();
        }
    }

    public static void restoreDefaults() {
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                IOptionConvertable option;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class)) continue;
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanOption)field.get(null);
                    OptionStorage.setBoolean(((BooleanOption)option).getKey(), ((BooleanOption)option).getDefaultValue());
                    continue;
                }
                if (!EnumOption.class.isAssignableFrom(field.getType())) continue;
                option = (EnumOption)field.get(null);
                OptionStorage.setEnumRaw(((EnumOption)option).getKey(), ((EnumOption)option).getDefaultValue());
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Couldn't restore Interaction Manager config to defaults.");
            e.printStackTrace();
        }
    }

    public static boolean areOptionValuesSetToDefault() {
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                IOptionConvertable option;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class) || !(BooleanOption.class.isAssignableFrom(field.getType()) ? ((BooleanOption)(option = (BooleanOption)field.get(null))).getValue() != ((BooleanOption)option).getDefaultValue() : EnumOption.class.isAssignableFrom(field.getType()) && ((EnumOption)(option = (EnumOption)field.get(null))).getValue() != ((EnumOption)option).getDefaultValue())) continue;
                return false;
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Couldn't check if Interaction Manager config is set to defaults.");
            e.printStackTrace();
        }
        return true;
    }

    public static void initRuntimeOptions() {
        Config.IS_MODMENU_INSTALLED.setValue(FabricLoader.getInstance().getModContainer("modmenu").isPresent());
    }

    private static void setupConfigFile() {
        if (config_path != null) {
            return;
        }
        config_path = FabricLoader.getInstance().getConfigDir().resolve("interactionmanager.json");
    }
}

